// Fibonacci.sc:
//
// 07/23/02 written by R. Doemer, inspired by Jonathan Mathai

#include <stdio.h>
#include <stdlib.h>


behavior Init1(inout signal int R1)
{
    void main(void)
    {
	R1 = 0;
    }
};

behavior Init2(inout signal int R2)
{
    void main(void)
    {
	R2 = 1;
    }
};

behavior Init(signal int R1, signal int R2)
{
    Init1 i1(R1);
    Init2 i2(R2);

    void main(void)
    {
	par {	i1.main();
		i2.main();
	}
    }
};

behavior Comp1(signal int R1, signal int R2)
{
    void main(void)
    {
	R1 = R2;
    }
};

behavior Comp2(signal int R1, signal int R2)
{
    void main(void)
    {
	R2 += R1;
    }
};

behavior Comp(signal int R1, signal int R2)
{
    Comp1 c1(R1, R2);
    Comp2 c2(R1, R2);

    void main(void)
    {
	par {	c1.main();
		c2.main();
	}
    }
};

behavior Main
{
    int		i, n;
    signal int	R1, R2;
    Init	init(R1, R2);
    Comp	comp(R1, R2);

    int main(int argc, char **argv)
    {
	if (argc == 2)
	   { n = atoi(argv[1]);
	    } /* fi */
	else
	   { n = 10;
	    } /* esle */

	init.main();

	for(i=0; i<n; i++)
	{
	    wait R2;
	    printf("%d\n", R2);
	    comp.main();
	}
	return(0);
    }
};

// EOF
