/************************************************************************/
/* IntRep/List.h: SpecC Internal Representation, List Template Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 09/24/97 */
/************************************************************************/

/* last update: 06/15/04 */

/* modifications: (most recent first)
 *
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 08/17/01 RD	added index-based access methods Index()
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	introduced this header (last change was 12/07/98)
 */

#ifndef INTREP_LIST_H
#define INTREP_LIST_H


#include "Global.h"
#include "IntRep/Unit.h"


/*** container template class, general purpose list *********************/


template <class item_type>	class SIR_ListElem;	/* forward decl. */
template <class item_type>	class SIR_List;


	/****************/
	/*** SIR_List ***/
	/****************/


template <class item_type>	/* template class for */
class SIR_List :		/* any list header    */
	public SIR_Unit			/* is a unit of the design */
{
item_type	*FirstItem;	/* internal data */
item_type	*LastItem;
item_type	*CurrItem;
unsigned int	NumberItems;

public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_List(				/* constructor #1 */
	item_type	*FirstElement = NULL);

~SIR_List(void);			/* destructor */


bool Empty(void);			/* test for empty list? */

unsigned int NumElements(void);		/* number of list elements */

item_type *First(void);			/* first element (NULL if empty) */

item_type *Last(void);			/* last element (NULL if empty) */

item_type *Previous(void);		/* previous element (NULL if none) */

item_type *Curr(void);			/* current element (NULL if none) */

item_type *Next(void);			/* next element (NULL if none) */

item_type *Index(			/* n-th element (NULL if none) */
	unsigned int	Num);		/* (first is 0; linear search!) */

item_type *Prepend(			/* prepend one element */
	item_type	*Elem);

item_type *Append(			/* append one element */
	item_type	*Elem);

item_type *InsertBefore(		/* insert before current (#1) */
	item_type	*Elem);

item_type *InsertBefore(		/* insert before given one (#2) */
	item_type	*Elem,
	item_type	*Succ);

item_type *InsertAfter(			/* insert after current (#1) */
	item_type	*Elem);

item_type *InsertAfter(			/* insert after given one (#2) */
	item_type	*Elem,
	item_type	*Pred);

item_type *Remove(			/* remove one element */
	item_type	*Elem);

SIR_ListElem<item_type> *Remove(	/* remove one element */
	SIR_ListElem<item_type>	*Elem);

item_type	*Remove(void);		/* remove current element */

SIR_List<item_type> *Concat(		/* concatenate two lists */
	SIR_List<item_type>	*Appendix);

SIR_List<item_type> *Precat(		/* concatenate two lists */
	SIR_List<item_type>	*Prependix);
};


	/********************/
	/*** SIR_ListElem ***/
	/********************/


template <class item_type>	/* template class for */
class SIR_ListElem :		/* any list element   */
	public SIR_Unit			/* is a unit of the design */
{
friend class SIR_List<item_type>;

item_type	*SuccItem;	/* internal data */
item_type	*PredItem;
SIR_List<item_type> *ListHead;

public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_ListElem(void);		/* constructor #1 */

~SIR_ListElem(void);		/* destructor */


ERROR Write(			/* writes a binary representation to file */
	FILE	*File);		/* (empty default, should be overloaded) */

static item_type *Read(		/* reads a binary representation from file */
	FILE		*File,	/* (empty default, should be overloaded) */
	unsigned long	*CountID,
	void		*UnitTable[],
	unsigned long	NumUnits);



item_type *Succ(void);		/* Successor */

item_type *Pred(void);		/* Predecessor */

SIR_List<item_type> *Head(void);/* List head */

void Remove(void);		/* remove myself */

unsigned int Index(void);	/* index of this element */
				/* (first is 0; linear search!) */
};


#include "IntRep/List2.h"	/* insert template implementation */


#endif /* INTREP_LIST_H */

/* EOF IntRep/List.h */
