// notifyone5.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior A(in event e, inout int x)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { wait e;
	     x++;
	    }
	}
};

behavior B(in event e, inout int y)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { wait e;
	     y++;
	    }
	}
};

behavior C(in event e, inout int z)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { wait e;
	     z++;
	    }
	}
};

behavior D(out event e, in int x, in int y, in int z)
{
	void main(void)
	{
	int	i;

	for(i=0; i<10; i++)
	   { notifyone e;
	     waitfor(1);
	    }
	assert(x + y + z == 10);

	for(i=0; i<10; i++)
	   { notifyone e;
	     waitfor(1);
	    }
	assert(x + y + z == 20);

	for(i=0; i<10; i++)
	   { notifyone e;
	     waitfor(1);
	    }
	assert(x + y + z == 30);

	for(i=0; i<70; i++)
	   { notifyone e;
	     waitfor(1);
	    }
	assert(x + y + z == 100);

	for(i=0; i<100; i++)
	   { notifyone e;
	     waitfor(1);
	    }
	assert(x + y + z == 200);

	for(i=0; i<100; i++)
	   { notifyone e;
	     waitfor(1);
	    }
	assert(x + y + z == 300);
	}
};

behavior Main
{
	event	e;
	int	x = 0;
	int	y = 0;
	int	z = 0;
	A	a(e, x);
	B	b(e, y);
	C	c(e, z);
	D	d(e, x, y, z);

	int main(void)
	{
	puts("notifyone5: Starting...");

	par {	a.main();
		b.main();
		c.main();
		d.main();
		};
	assert(x + y + z == 300);
	assert(now() == 300);

	puts("notifyone5: Done.");
	return(0);
	}
};

// EOF
