/************************************************************************/
/* piped.h: SpecC run-time simulation library, 'piped' template impl.	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 03/28/01 */
/************************************************************************/

/* last update: 09/07/01 */

/* modifications: (most recent first)
 *
 * 09/07/01 RD	bug fix: modified 'piped' template to use static memory
 * 04/25/01 RD	added copy-assignment method (bug fix)
 * 04/04/01 RD	completed function bodies
 * 04/03/01 RD	inserted initial implementation
 * 03/28/01 RD	initial version
 */

#ifndef __PIPED_H
#define __PIPED_H

/* NOTE:							*/
/*	this "header" file contains the _implementation_ of	*/
/*	the 'piped' template class				*/


/*** class implementations **********************************************/


	/**********************/
	/*** piped template ***/
	/**********************/


template<class T, unsigned int d> inline
piped<T,d>::piped(void)			/* constructor */
{

/* nothing to do */

} /* end of piped<T,d>::piped */


template<class T, unsigned int d> inline
piped<T,d>::~piped(void)		/* destructor */
{

/* nothing to do */

} /* end of piped<T,d>::~piped */


template<class T, unsigned int d> inline
piped<T,d>::operator T() const		/* conversion operator (read access) */
{

return(Value[0]);

} /* end of piped<T,d>::operator T */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator=(	/* assignment operator #1 */
	T	Var)
{

Value[d] = Var;

return *this;

} /* end of piped<T,d>::operator= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator=(	/* assignment operator #1b */
	const piped<T,d> &PipedVar)	/* (needed, otherwise compiler  */
{					/* will generate 'bad' default) */

Value[d] = PipedVar.Value[0];

return *this;

} /* end of piped<T,d>::operator= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator+=(	/* assignment operator #2 */
	T	Var)
{

Value[d] = Value[0] + Var;

return *this;

} /* end of piped<T,d>::operator+= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator-=(	/* assignment operator #3 */
	T	Var)
{

Value[d] = Value[0] - Var;

return *this;

} /* end of piped<T,d>::operator-= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator*=(	/* assignment operator #4 */
	T	Var)
{

Value[d] = Value[0] * Var;

return *this;

} /* end of piped<T,d>::operator*= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator/=(	/* assignment operator #5 */
	T	Var)
{

Value[d] = Value[0] / Var;

return *this;

} /* end of piped<T,d>::operator/= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator%=(	/* assignment operator #6 */
	T	Var)
{

Value[d] = Value[0] % Var;

return *this;

} /* end of piped<T,d>::operator%= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator^=(	/* assignment operator #7 */
	T	Var)
{

Value[d] = Value[0] ^ Var;

return *this;

} /* end of piped<T,d>::operator^= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator&=(	/* assignment operator #8 */
	T	Var)
{

Value[d] = Value[0] & Var;

return *this;

} /* end of piped<T,d>::operator&= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator|=(	/* assignment operator #9 */
	T	Var)
{

Value[d] = Value[0] | Var;

return *this;

} /* end of piped<T,d>::operator|= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator<<=(	/* assignment operator #10 */
	T	Var)
{

Value[d] = Value[0] << Var;

return *this;

} /* end of piped<T,d>::operator<<= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator>>=(	/* assignment operator #11 */
	T	Var)
{

Value[d] = Value[0] >> Var;

return *this;

} /* end of piped<T,d>::operator>>= */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator++()	/* increment operator #1 (pre-) */
{

Value[d] = Value[0] + 1;

return *this;

} /* end of piped<T,d>::operator++ */


template<class T, unsigned int d> inline
piped<T,d> piped<T,d>::operator++(int)	/* increment operator #2 (post-) */
{
piped<T,d>	Tmp = *this;

Value[d] = Value[0] + 1;

return Tmp;

} /* end of piped<T,d>::operator++ */


template<class T, unsigned int d> inline
piped<T,d> &piped<T,d>::operator--()	/* decrement operator #1 (pre-) */
{

Value[d] = Value[0] - 1;

return *this;

} /* end of piped<T,d>::operator-- */


template<class T, unsigned int d> inline
piped<T,d> piped<T,d>::operator--(int)	/* decrement operator #2 (post-) */
{
piped<T,d>	Tmp = *this;

Value[d] = Value[0] - 1;

return Tmp;

} /* end of piped<T,d>::operator-- */


template<class T, unsigned int d>
void piped<T,d>::update(		/* shift the data in the pipeline */
	void)
{
unsigned int	i;

for(i=0; i<d; i++)
   { Value[i] = Value[i+1];
    } /* rof */

} /* end of piped<T,d>::update */


#endif /* __PIPED_H */

/* EOF piped.h */
