/************************************************************************/
/* IntRep/Design.h: SpecC Internal Representation, Design Class		*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 09/24/97 */
/************************************************************************/

/* last update: 11/16/01 */

/* modifications: (most recent first)
 *
 * 11/08/01 RD	switched code generation to use GL_IO layer
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	eliminated support for automatic IP wrapping (scc -ip option)
 * 05/25/01 RD	introduced this header (last change was 04/12/99)
 */

#ifndef INTREP_DESIGN_H
#define INTREP_DESIGN_H

#include "Global.h"
#include "IntRep/Symbol.h"


/*** constants and macros ***********************************************/


	/* (none) */


/*** type definitions ***************************************************/


typedef class SIR_Design		sir_design;


/*** class declarations *************************************************/


	/******************/
	/*** SIR_Design ***/
	/******************/


class SIR_Design :		/* root of the data structure */
	public SIR_Unit			/* is a unit of the design */
{
public:
string		Name;		/* name of this design */
sir_file_list	*FileList;	/* list of (source) files */
sir_import_list	*ImportList;	/* list of imported (binary) files */
sir_types	*Types;		/* list of all types in the description */
sir_symbols	*Symbols;	/* global symbol table */
sir_notes	*Notes;		/* global notes (NULL if none) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Design(			/* constructor #1 */
	const char	*Name);

SIR_Design(			/* constructor #3 (duplicator) */
	sir_design	*Original);

~SIR_Design(void);		/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

ERROR DFS_ForAllSymbols(	/* iterator over all symbols (depth first) */
	sir_symbol_mptr	MemberFct,
	sir_symbol_marg	MemberFctArg);

ERROR DFS_ForAllUserTypes(	/* iterator over all usertypes (depth first) */
	sir_usertp_mptr	MemberFct,
	sir_usertp_marg	MemberFctArg);

ERROR DFS_ForAllNotes(		/* iterator over all notes (depth first) */
	sir_note_mptr	MemberFct,
	sir_note_marg	MemberFctArg);

ERROR DFS_ForAllStatements(	/* iterator over all statements (depth first) */
	sir_stmnt_mptr	MemberFct,
	sir_stmnt_marg	MemberFctArg);


ERROR Annotate(			/* attach a (global) note to the design */
	sir_note	*NewNote);	/* (consumes NewNote) */

ERROR Integrate(		/* integrates an imported design */
	sir_design	*Imported,	/* (consumes the imported design) */
	const char	*ImportFile = NULL,	/* (default: no warnings) */
	const char	*SourceFile = NULL,
	unsigned int	LineNumber = 0);

void GarbageCollection(void);	/* garbage collector */


ERROR WriteSC(			/* (re-) generates SpecC source code */
	GL_HANDLE	*IO,
	const char	*Filename,	/* (full path) */
	BOOL		WriteNotes = TRUE,
	BOOL		WriteLines = TRUE);

ERROR WriteH(			/* generates C++ source code: header file */
	GL_HANDLE	*IO,
	const char	*Filename,	/* (full path) */
	BOOL		WriteNotes = TRUE,
	BOOL		WriteLines = TRUE);

ERROR WriteCC(			/* generates C++ source code: main file */
	GL_HANDLE	*IO,
	const char	*Filename,	/* (full path) */
	const char	*Headername,	/* (full path) */
	BOOL		WriteNotes = TRUE,
	BOOL		WriteLines = TRUE);
};


/*** exported variables *************************************************/


	/* none */


/************************************************************************/
/*** prototype definitions for exported functions		      ***/
/************************************************************************/


	/* none */


#endif /* INTREP_DESIGN_H */

/* EOF IntRep/Design.h */
