/************************************************************************/
/* PRS_Scanner.h: Scanner for Parser.c					*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 07/02/97 */
/************************************************************************/

/* last update: 11/15/01 */

/* modifications: (most recent first)
 *
 * 11/15/01 RD	made grammar selector visible to parser
 * 05/30/01 RD	reduced contents to reference compiler needs
 * 05/04/01 RD	added support for import of SpecC source (.sc) files
 * 05/03/01 RD	introduced this header (last change was 05/19/99)
 */

#ifndef PRS_SCANNER_H
#define PRS_SCANNER_H


#include "Global.h"
#include "Parser.h"


/*** constants and macros ***********************************************/


/* #define PRS_SCANNER_DEBUG_COMMENTS */	/* comment eating debugging */
/* #define PRS_SCANNER_DEBUG_STRINGS */		/* string token debugging */
/* #define PRS_SCANNER_DEBUG_CPPLINES */	/* cpp directive debugging */
/* #define PRS_SCANNER_DEBUG_TOKENS */		/* token value debugging */


/*** enumerators ********************************************************/


enum PRS_GrammarType		/* supported (sub-) grammars */
{
PRS_PARSE_LANGUAGE
};


/*** type declarations **************************************************/


typedef enum PRS_GrammarType	prs_grammar;

typedef class PRS_ScannerToken	prs_lineinfo;
typedef class PRS_StringToken	prs_stringtoken;
typedef class PRS_NameToken	prs_nametoken;
typedef class PRS_ConstToken	prs_consttoken;
typedef class PRS_StackItem	prs_stackitem;


/*** class declarations *************************************************/


class PRS_ScannerToken
{
public:
unsigned int	Line;		/* line number of the token */
sir_fileinfo	*FileInfo;	/* pointer to source file entry in file list */

PRS_ScannerToken(void);
~PRS_ScannerToken(void);
};


class PRS_StringToken	: public PRS_ScannerToken
{
public:
string		CharString;
};


class PRS_NameToken	: public PRS_ScannerToken
{
public:
string		Name;
sir_symbol	*Symbol;
};


class PRS_ConstToken	: public PRS_ScannerToken
{
public:
sir_constant	*Const;
};


class PRS_StackItem
{
public:
prs_stackitem	*Next;
string		NestedFileName;
string		PreprocName;
sir_design	*Design;
unsigned int	LineNo;
string		FileName;
sir_fileinfo	*FileInfo;
FILE		*File;
void		*Buffer;	// (YY_BUFFER_STATE is not available here)

PRS_StackItem(
	prs_stackitem	*Next,
	const char	*NestedFileName,
	const char	*PreprocName,
	sir_design	*Design,
	unsigned int	LineNo,
	string		FileName,
	sir_fileinfo	*FileInfo,
	FILE		*File,
	void		*Buffer);

~PRS_StackItem(void);
};


/*** exported variables *************************************************/


extern sir_design	*PRS_TheDesign;		/* the current design */
extern sir_symbols	*PRS_CurrScope;		/* the current scope */
extern unsigned int	PRS_lineno;		/* current line number */
extern string		PRS_CurrentFile;	/* current filename */
extern sir_fileinfo	*PRS_CurrFileInfo;	/* current fileinfo */
extern GL_STRINGLIST	*PRS_ImportDirList;	/* paths to search for import */
extern char		*PRS_text;		/* current text */
extern FILE		*PRS_in;		/* handle for input stream */

extern prs_grammar	PRS_GrammarType;	/* selected grammar type */
extern prs_stackitem	*PRS_FileStack;		/* stack of nested files */


/*** prototypes of exported functions ***********************************/


extern int	PRS_lex(void);		/* get next token */

extern int	PRS_parse(void);	/* (in fact, exported by yacc-parser) */


extern void	PRS_Initialize(		/* initialize (reset) the scanner */
	FILE		*NewInputHandle,
	prs_grammar	GrammarType = PRS_PARSE_LANGUAGE);


extern ERROR PRS_Push(			/* start parsing a nested file */
	const char	*NestedName,	/* (import a SpecC source file) */
	const char	*DesignName,
	const char	*PreprocName);

extern sir_design *PRS_Pop(	/* resume parsing after importing a file */
	string		*ImportFileName = NULL);

extern void PRS_ClearStack(void);	/* clean up the stack (if any) */


#endif /* PRS_SCANNER_H */

/* EOF PRS_Scanner.h */
