// Constructors.sc

long long global_l  = 17.42f;      // construction from double
double    global_d2 = 123456LL;    // construction from long long
long long global_l2 = 011101b;     // construction from bitvector
double    global_d  = 10101011b;
bit[32]   global_b1 = 12345678LL;  // construction from long long
bit[8]    global_b2 = 12.3456f;    // construction from double

behavior LLongDouble(inout double d1)
{
  long long l  = 17.42f;     // construction from double
  double    d2 = 123456LL;   // construction from long long
  
  void main(void)
  {    
    d2 = d1  + l;       // (long long)+(double) -> (double)+(double)
    
    l  = d2;            // (double) -> (long long)
    d1 = l;             // (long long) -> (double)
    
    l = l + d1;         // combination...
  }
};

behavior BitVec(in bit[16] bv)
{
  long long l = 011101b;    // construction from bitvector
  double    d = 10101011b;
  
  bit[32] b1 = 12345678LL;  // construction from long long
  bit[8]  b2 = 12.3456f;    // construction from double
  
  void main(void)
  {        
    l = b1 + d;         // (bit)+(double) -> (double)+(double) -> (long long)

    b2 = l;             // (long long) -> (bit)
    d  = b2;            // (bit) -> (double)
    
    d = b1 + l;         // (bit)+(long long) -> (bit)+(bit) -> (double)
    
    b2 = d;             // (double) -> (bit)
    l  = b2;            // (bit) -> (long long)
  }
};

behavior Main()
{
  double  d = 14;
  bit[16] b = 4;
  
  LLongDouble B1(d);
  BitVec      B2(b);
  
  int main(void)
  {
    B1.main();
    B2.main();
    return 0;
  }
};

// EOF
