/************************************************************************/
/* IntRep/Error.h: SpecC Internal Representation, Error Handling	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 10/10/97 */
/************************************************************************/

/* last update: 12/28/01 */

/* modifications: (most recent first)
 *
 * 11/08/01 RD	removed SIR_ERROR_WRITING_SPECC_FILE
 * 05/31/01 RD	removed code not needed for the SCRC
 * 02/14/01 RD	started this list (last changes was 04/08/99)
 */


#ifndef INTREP_ERROR_H
#define INTREP_ERROR_H


#include "Global.h"


/*** constants and macros ***********************************************/


	/* error codes for this module */

#define SIR_ERROR_NO_ERROR			(NO_ERROR)
#define SIR_ERROR_FLAG_YES			(FLAG_YES)
#define SIR_ERROR_FLAG_NO			(FLAG_NO)
#define SIR_ERROR_TYPE_CONFLICT			(SIR_ERROR_BASE +   1)
#define SIR_ERROR_TYPE_SIGNED_BOOL		(SIR_ERROR_BASE +   2)
#define SIR_ERROR_TYPE_SIGNED_FLOAT		(SIR_ERROR_BASE +   3)
#define SIR_ERROR_TYPE_SIGNED_DOUBLE		(SIR_ERROR_BASE +   4)
#define SIR_ERROR_TYPE_SIGNED_LONGDOUBLE	(SIR_ERROR_BASE +   5)
#define SIR_ERROR_TYPE_SIGNED_VOID		(SIR_ERROR_BASE +   6)
#define SIR_ERROR_TYPE_PIPED_EVENT		(SIR_ERROR_BASE +   7)
#define SIR_ERROR_TYPE_SIGNED_EVENT		(SIR_ERROR_BASE +   8)
#define SIR_ERROR_TYPE_CONST_OR_VOLATILE_EVENT	(SIR_ERROR_BASE +   9)
#define SIR_ERROR_TYPE_SIGNED_TWICE		(SIR_ERROR_BASE +  10)
#define SIR_ERROR_TYPE_UNSIGNED_TWICE		(SIR_ERROR_BASE +  11)
#define SIR_ERROR_TYPE_CONST_TWICE		(SIR_ERROR_BASE +  12)
#define SIR_ERROR_TYPE_VOLATILE_TWICE		(SIR_ERROR_BASE +  13)
#define SIR_ERROR_TYPE_INT_TWICE		(SIR_ERROR_BASE +  14)
#define SIR_ERROR_TYPE_SIGNED_AND_UNSIGNED	(SIR_ERROR_BASE +  15)
#define SIR_ERROR_TYPE_INTLONGDOUBLE		(SIR_ERROR_BASE +  16)
#define SIR_ERROR_TYPE_MULTIPLE_STORAGE_CLASSES	(SIR_ERROR_BASE +  17)
#define SIR_ERROR_UNDEFINED_LABEL		(SIR_ERROR_BASE +  18)
#define SIR_ERROR_REDEFINITION_OF_LABEL		(SIR_ERROR_BASE +  19)
#define SIR_ERROR_REDEFINITION_OF_USERTYPE_1	(SIR_ERROR_BASE +  20)
#define SIR_ERROR_REDEFINITION_OF_USERTYPE_2	(SIR_ERROR_BASE +  21)
#define SIR_ERROR_REDEFINITION_OF_USERTYPE_3	(SIR_ERROR_BASE +  22)
#define SIR_ERROR_USERTYPE_MISMATCH_1		(SIR_ERROR_BASE +  23)
#define SIR_ERROR_USERTYPE_MISMATCH_2		(SIR_ERROR_BASE +  24)
#define SIR_ERROR_ILLEGAL_SIZEOF_VOID		(SIR_ERROR_BASE +  25)
#define SIR_ERROR_ILLEGAL_SIZEOF_EVENT		(SIR_ERROR_BASE +  26)
#define SIR_ERROR_ILLEGAL_SIZEOF_FUNCTION	(SIR_ERROR_BASE +  27)
#define SIR_ERROR_EXPRESSION_NOT_CONSTANT	(SIR_ERROR_BASE +  28)
#define SIR_ERROR_CONST_EXPR_NOT_INTEGER	(SIR_ERROR_BASE +  29)
#define SIR_ERROR_DIVISION_BY_ZERO		(SIR_ERROR_BASE +  30)
#define SIR_ERROR_NOTE_SPECIFIED_TWICE		(SIR_ERROR_BASE +  31)
#define SIR_ERROR_NOTE_SPECIFIED_TWICE_2	(SIR_ERROR_BASE +  32)
#define SIR_ERROR_SYMBOL_DEFINED_TWICE_1	(SIR_ERROR_BASE +  33)
#define SIR_ERROR_SYMBOL_DEFINED_TWICE_2	(SIR_ERROR_BASE +  34)
#define SIR_ERROR_SYMBOL_STORAGE_MISMATCH_1	(SIR_ERROR_BASE +  35)
#define SIR_ERROR_SYMBOL_STORAGE_MISMATCH_2	(SIR_ERROR_BASE +  36)
#define SIR_ERROR_DECLARATION_MISMATCH_1	(SIR_ERROR_BASE +  37)
#define SIR_ERROR_DECLARATION_MISMATCH_2	(SIR_ERROR_BASE +  38)
#define SIR_ERROR_DECLARATION_MISMATCH_3	(SIR_ERROR_BASE +  39)
#define SIR_ERROR_DECLARATION_MISMATCH_4	(SIR_ERROR_BASE +  40)
#define SIR_ERROR_REDEFINITION_OF_SYMBOL	(SIR_ERROR_BASE +  47)
#define SIR_ERROR_REDEFINITION_OF_FUNCTION	(SIR_ERROR_BASE +  48)
#define SIR_ERROR_REDEFINITION_OF_BEHAVIOR	(SIR_ERROR_BASE +  49)
#define SIR_ERROR_REDEFINITION_OF_CHANNEL	(SIR_ERROR_BASE +  50)
#define SIR_ERROR_REDEFINITION_OF_INTERFACE	(SIR_ERROR_BASE +  51)
#define SIR_ERROR_REDEFINITION_OF_SYMBOL_2	(SIR_ERROR_BASE +  52)
#define SIR_ERROR_REDEFINITION_OF_FUNCTION_2	(SIR_ERROR_BASE +  53)
#define SIR_ERROR_REDEFINITION_OF_BEHAVIOR_2	(SIR_ERROR_BASE +  54)
#define SIR_ERROR_REDEFINITION_OF_CHANNEL_2	(SIR_ERROR_BASE +  55)
#define SIR_ERROR_REDEFINITION_OF_INTERFACE_2	(SIR_ERROR_BASE +  56)
//      SIR_ERROR_WRITING_SPECC_FILE		(SIR_ERROR_BASE +  57)
#define SIR_ERROR_DOUBLE_IMP_SYMBOL_NOT_FOUND	(SIR_ERROR_BASE +  58)
#define SIR_ERROR_DOUBLE_IMP_USRTP_NOT_FOUND	(SIR_ERROR_BASE +  59)
#define SIR_ERROR_DOUBLE_IMP_USRTP_NOT_FOUND_2	(SIR_ERROR_BASE +  60)
#define SIR_ERROR_FORBIDDEN_INITIALIZER		(SIR_ERROR_BASE +  61)
#define SIR_ERROR_ILLEGAL_STORAGE_CLASS		(SIR_ERROR_BASE +  62)
#define SIR_ERROR_USERTYPE_DEF_IN_PARAMETERS	(SIR_ERROR_BASE +  63)
#define SIR_ERROR_USERTYPE_CYCLIC_NESTING	(SIR_ERROR_BASE +  64)
#define SIR_ERROR_INSTANCE_CYCLIC_NESTING	(SIR_ERROR_BASE +  65)
#define SIR_ERROR_CLASS_CYCLIC_NESTING		(SIR_ERROR_BASE +  66)
#define SIR_ERROR_NO_MAIN_METHOD		(SIR_ERROR_BASE +  67)
#define SIR_ERROR_MEMBER_MAIN_NOT_A_METHOD	(SIR_ERROR_BASE +  68)
#define SIR_ERROR_MAIN_METHOD_TYPE_MISMATCH	(SIR_ERROR_BASE +  69)
#define SIR_ERROR_NO_PORTS_ALLOWED_FOR_MAIN	(SIR_ERROR_BASE +  70)
#define SIR_ERROR_NO_INTERFACES_ALLOWED_FR_MAIN	(SIR_ERROR_BASE +  71)
#define SIR_ERROR_COMPOUND_STMNT_NOT_CLEAN	(SIR_ERROR_BASE +  72)
#define SIR_ERROR_COMPLEX_MEMBER_INITIALIZER	(SIR_ERROR_BASE +  73)
#define SIR_ERROR_ILLEGAL_INTERFACE_MEMBER	(SIR_ERROR_BASE +  74)
#define SIR_ERROR_CALL_OF_NON_FUNCTION		(SIR_ERROR_BASE +  75)
#define SIR_ERROR_INVALID_OPERAND_FOR_CONCAT	(SIR_ERROR_BASE +  76)
#define SIR_ERROR_INVALID_OPERAND_FOR_BITSLICE	(SIR_ERROR_BASE +  77)
#define SIR_ERROR_INVALID_SLICE_FOR_BITSLICE	(SIR_ERROR_BASE +  78)
#define SIR_ERROR_INVALID_ARRAY_INDEX		(SIR_ERROR_BASE +  79)
#define SIR_ERROR_INVALID_OPERAND_FOR_ARRAY_ACC	(SIR_ERROR_BASE +  80)
#define SIR_ERROR_INVALID_OPERAND_FOR_COND_EXPR	(SIR_ERROR_BASE +  81)
#define SIR_ERROR_INVALID_OPERAND_FOR_BOOL_OP	(SIR_ERROR_BASE +  82)
#define SIR_ERROR_INVALID_OPERAND_FOR_BIT_OP	(SIR_ERROR_BASE +  83)
#define SIR_ERROR_INVALID_OPERAND_FOR_INCR_DECR	(SIR_ERROR_BASE +  84)
#define SIR_ERROR_INVALID_OPERAND_FOR_SHIFT_OP	(SIR_ERROR_BASE +  85)
#define SIR_ERROR_INVALID_OPERAND_FOR_MODULO_OP	(SIR_ERROR_BASE +  86)
#define SIR_ERROR_INVALID_OPERAND_FOR_ARITH_OP	(SIR_ERROR_BASE +  87)
#define SIR_ERROR_INVALID_POINTER_ARITHMETIC	(SIR_ERROR_BASE +  88)
#define SIR_ERROR_OPERAND_NOT_POINTER_OR_ARRAY	(SIR_ERROR_BASE +  89)
#define SIR_ERROR_ILLEGAL_SIZEOF_CLASS		(SIR_ERROR_BASE +  90)
#define SIR_ERROR_PORT_MAPPING_MISMATCH_1	(SIR_ERROR_BASE +  91)
#define SIR_ERROR_PORT_MAPPING_MISMATCH_2	(SIR_ERROR_BASE +  92)
#define SIR_ERROR_PORT_MAPPING_MISMATCH_3	(SIR_ERROR_BASE +  93)
#define SIR_ERROR_PORT_MAPPING_MISMATCH_4	(SIR_ERROR_BASE +  94)
#define SIR_ERROR_PORT_MAPPING_MISMATCH_5	(SIR_ERROR_BASE +  95)
#define SIR_ERROR_PORT_MAPPING_MISMATCH_6	(SIR_ERROR_BASE +  96)
#define SIR_ERROR_PORT_MAPPING_MISMATCH_7	(SIR_ERROR_BASE +  97)
#define SIR_ERROR_PORT_MAPPING_MISMATCH_8	(SIR_ERROR_BASE +  98)
#define SIR_ERROR_PORT_MAPPING_MISMATCH_9	(SIR_ERROR_BASE +  99)
#define SIR_ERROR_PORT_MAPPING_MISMATCH_10	(SIR_ERROR_BASE + 100)
#define SIR_ERROR_RESERVED_SYMBOL_NAME		(SIR_ERROR_BASE + 101)
#define SIR_ERROR_RESERVED_SYMBOL_NAME_2	(SIR_ERROR_BASE + 102)
#define SIR_ERROR_MEMBER_HIDES_USED_GLOBAL_SYMB	(SIR_ERROR_BASE + 103)
#define SIR_ERROR_LEFT_ARG_NOT_A_POINTER	(SIR_ERROR_BASE + 104)
#define SIR_ERROR_NOT_AN_AGGREGATE_OR_CLASS	(SIR_ERROR_BASE + 105)
#define SIR_ERROR_ACCESS_TO_INCOMPLETE_TYPE	(SIR_ERROR_BASE + 106)
#define SIR_ERROR_ACCESS_TO_INCOMPLETE_INTERFC	(SIR_ERROR_BASE + 107)
#define SIR_ERROR_ACCESS_TO_INCOMPLETE_IF_1	(SIR_ERROR_BASE + 108)
#define SIR_ERROR_ACCESS_TO_INCOMPLETE_IF_2	(SIR_ERROR_BASE + 109)
#define SIR_ERROR_IMPLEMENTS_INCOMPLETE_IF	(SIR_ERROR_BASE + 110)
#define SIR_ERROR_NO_SUCH_MEMBER_IN_USERTYPE	(SIR_ERROR_BASE + 111)
#define SIR_ERROR_NO_SUCH_METHOD_IMPLEMENTED_1	(SIR_ERROR_BASE + 112)
#define SIR_ERROR_NO_SUCH_METHOD_IMPLEMENTED_2	(SIR_ERROR_BASE + 113)
#define SIR_ERROR_NO_SUCH_METHOD_IN_INTERFACE	(SIR_ERROR_BASE + 114)
#define SIR_ERROR_CYCLIC_INSTANTIATION		(SIR_ERROR_BASE + 115)
#define SIR_ERROR_CYCLIC_INSTANTIATION_2	(SIR_ERROR_BASE + 116)
#define SIR_ERROR_CLASS_CONTAINMENT_CYCLE	(SIR_ERROR_BASE + 117)
#define SIR_ERROR_CLASS_LACKS_IMPLEMENTATION	(SIR_ERROR_BASE + 118)
#define SIR_ERROR_CLASS_LACKS_IMPLEMENTATION_2	(SIR_ERROR_BASE + 119)
#define SIR_ERROR_IMPLEMENTATION_TYPE_MISMATCH	(SIR_ERROR_BASE + 120)
#define SIR_ERROR_IMPLEMENTATION_TYPE_MISMATCH2	(SIR_ERROR_BASE + 121)
#define SIR_ERROR_LABEL_REQUIRED		(SIR_ERROR_BASE + 138)
#define SIR_ERROR_BITSLICE_OUT_OF_RANGE		(SIR_ERROR_BASE + 141)
#define SIR_ERROR_TYPE_VOID_NOT_ALLOWED		(SIR_ERROR_BASE + 147)
#define SIR_ERROR_TYPE_EVENT_NOT_PLAIN		(SIR_ERROR_BASE + 148)
#define SIR_ERROR_TYPE_AGGREGATE_NOT_DEFINED	(SIR_ERROR_BASE + 149)
#define SIR_ERROR_TYPE_FUNCTION_RETURNS_ARRAY	(SIR_ERROR_BASE + 150)
#define SIR_ERROR_PORT_DIRECTION_REQUIRED	(SIR_ERROR_BASE + 151)
#define SIR_ERROR_ILLEGAL_PORT_DIRECTION	(SIR_ERROR_BASE + 152)
#define SIR_ERROR_METHOD_IS_IMPLEMENTED		(SIR_ERROR_BASE + 154)
#define SIR_ERROR_DOUBLE_DEFINITION_OF_LABEL	(SIR_ERROR_BASE + 159)
#define SIR_ERROR_RETURN_TYPE_MISMATCH		(SIR_ERROR_BASE + 160)
#define SIR_ERROR_ARGUMENT_TYPE_MISMATCH	(SIR_ERROR_BASE + 161)
#define SIR_ERROR_TOO_MANY_ARGUMENTS		(SIR_ERROR_BASE + 162)
#define SIR_ERROR_TOO_FEW_ARGUMENTS		(SIR_ERROR_BASE + 163)
#define SIR_ERROR_COMPLEX_INIT_FOR_PLAIN_TYPE	(SIR_ERROR_BASE + 164)
#define SIR_ERROR_COMPLEX_INIT_FOR_POINTER_TYPE	(SIR_ERROR_BASE + 165)
#define SIR_ERROR_INITIALIZER_TYPE_MISMATCH	(SIR_ERROR_BASE + 166)
#define SIR_ERROR_ILLEGAL_INITIALIZER		(SIR_ERROR_BASE + 167)
#define SIR_ERROR_INIT_INCOMPLETE_STRUCTURE	(SIR_ERROR_BASE + 168)
#define SIR_ERROR_PLAIN_INIT_FOR_STRUCTURE	(SIR_ERROR_BASE + 169)
#define SIR_ERROR_PLAIN_INIT_FOR_ARRAY		(SIR_ERROR_BASE + 170)
#define SIR_ERROR_TOO_MANY_INITIALIZERS_1	(SIR_ERROR_BASE + 171)
#define SIR_ERROR_TOO_MANY_INITIALIZERS_2	(SIR_ERROR_BASE + 172)
#define SIR_ERROR_INVALID_ARRAY_ASSIGNMENT	(SIR_ERROR_BASE + 173)
#define SIR_ERROR_TIME_CONSTRAINT_UNSPECIFIED	(SIR_ERROR_BASE + 174)
#define SIR_ERROR_CONSTRAINT_LABEL_NOT_IN_DO	(SIR_ERROR_BASE + 175)
#define SIR_ERROR_CONSTRAINT_ALREADY_EXISTS	(SIR_ERROR_BASE + 176)
#define SIR_ERROR_CREATED_INTERFACE_NOT_FOUND	(SIR_ERROR_BASE + 177)
#define SIR_ERROR_MODIFIABLE_LVALUE		(SIR_ERROR_BASE + 196)
#define SIR_ERROR_PORT_WRITE_ACCESS		(SIR_ERROR_BASE + 197)
#define SIR_ERROR_PORT_READ_ACCESS		(SIR_ERROR_BASE + 198)


/*** exported variables *************************************************/


extern string	SIR_ErrMsg;
extern ERROR	SIR_Error;		/* last error of this module */


/************************************************************************/
/*** prototype definitions for exported functions		      ***/
/************************************************************************/


	/*** error handling ***/


	/* recover from error status */

extern void SIR_Reset(void);

	/* error code to error message conversion */

extern const char *SIR_ErrorText(ERROR ErrorNumber);


#endif /* INTREP_ERROR_H */

/* EOF IntRep/Error.h */
