/************************************************************************/
/* sim.sh: SpecC run-time simulation library, user-level API in SpecC	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 03/21/01 */
/************************************************************************/

/* last update: 04/19/01 */

/* modifications: (most recent first)
 *
 * 04/19/01 RD	added comment regarding possible leading '-' for bit2str
 * 04/16/01 RD	renamed "SIM_Time" to "sim_time" and made it unsigned;
 *		added string conversion functions
 * 03/26/01 RD	added definition for _REENTRANT
 * 03/21/01 RD	initial version
 */

#ifndef __SIM_SH
#define __SIM_SH


/*** constants and macros ***********************************************/


#define _REENTRANT		/* necessary for some C library functions */


/*** type definitions ***************************************************/


typedef unsigned long long	sim_time;	/* type of simulation time */


/*** exported variables *************************************************/


	/* (none) */


/*** exported functions *************************************************/


extern sim_time now(			/* obtain current simulation time */
	void);

extern const char *time2str(		/* convert time to printable string */
	sim_time	Time);		/* (copy temporary internal buffer!) */

extern sim_time str2time(		/* convert printable string to time */
	const char	*str);

extern char *ll2str(			/* convert long long value to string */
	unsigned int	base,			/* 2 <= base <= 36 */
	char		*endptr,		/* last char in caller buffer */
	long long	ll);			/* long long value */

extern char *ull2str(			/* convert unsigned long long to str. */
	unsigned int	base,			/* 2 <= base <= 36 */
	char		*endptr,		/* last char in caller buffer */
	unsigned long long ull);		/* unsigned long long value */

extern long long str2ll(		/* convert string to long long value */
	unsigned int	base,			/* 2 <= base <= 36, or 0 */
	const char	*str);			/* NULL-terminated string */

extern unsigned long long str2ull(	/* convert string to unsigned l. long */
	unsigned int	base,			/* 2 <= base <= 36, or 0 */
	const char	*str);			/* NULL-terminated string */

extern char *bit2str(			/* convert bit vector to string */
	unsigned int	base,			/* 2 <= base <= 36 */
	char		*endptr,		/* last char in caller buffer */
	... /* bit[l:r] b */);			/* bit vector value */
					/* neg. value will give leading '-'! */

extern char *ubit2str(			/* convert unsigned bitvec. to string */
	unsigned int	base,			/* 2 <= base <= 36 */
	char		*endptr,		/* last char in caller buffer */
	... /* unsigned bit[l:r] b */);		/* unsigned bit vector value */

extern void str2bit(			/* convert string to bit vector */
	unsigned int	base,			/* 2 <= base <= 36, or 0 */
	const char	*str,			/* NULL-terminated string */
	... /* bit[l:r] *bptr */);		/* pointer to result */

extern void str2ubit(			/* convert string to unsigned bit v. */
	unsigned int	base,			/* 2 <= base <= 36, or 0 */
	const char	*str,			/* NULL-terminated string */
	... /* unsigned bit[l:r] *bptr */);	/* pointer to result */

#endif /* __SIM_SH */

/* EOF sim.sh */
