
/************************************************************************/
/* sim.h: SpecC run-time simulation library, user-level API in C++	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 03/21/01 */
/************************************************************************/

/* last update: 04/17/01 */

/* modifications: (most recent first)
 *
 * 04/17/01 RD	introduced preprocessing by 'sed' in order to allow
 *		switching between native and non-native 'long long' types
 * 04/16/01 RD	renamed "SIM_Time" to "sim_time";
 *		added string conversion functions
 * 03/26/01 RD	added definition for _REENTRANT
 * 03/22/01 RD	fixed the confusion protection condition
 * 03/21/01 RD	initial version
 */

// Note: this file has been preprocessed for use of
//       native 'long long' and 'unsigned long long' types



#ifndef __SIM_H
#define __SIM_H



/* avoid confusion with old version */
#ifndef __cplusplus
#ifdef __SPECC__
#error File "sim.h" is for C++ only. Use file "sim.sh" instead.
#endif /* __SPECC__ */
#endif /* __cplusplus */


/*** constants and macros ***********************************************/


#define _REENTRANT		/* necessary for some C library functions */


/*** type definitions ***************************************************/


typedef unsigned long long	sim_time;	/* type of simulation time */
						/* is 'unsigned long long' */




/*** exported variables *************************************************/


	/* (none) */


/************************************************************************/
/*** prototype definitions for exported functions		      ***/
/************************************************************************/


extern "C" sim_time now(		/* obtain current simulation time */
	void);

extern "C" const char *time2str(	/* convert time to printable string */
	sim_time	Time);		/* (copy temporary internal buffer!) */

extern "C" sim_time str2time(		/* convert printable string to time */
	const char	*str);


/* ll2str() is part of longlong module */

/* ull2str() is part of longlong module */

/* str2ll() is part of longlong module */

/* str2ull() is part of longlong module */

/* bit2str() is part of bit module */

/* ubit2str() is part of bit module */

/* str2bit() is part of bit module */

/* str2ubit() is part of bit module */


#endif /* __SIM_H */

/* EOF sim.h */
