// waitfor6.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior A(in event e, inout int x)
{
	void main(void)
	{
	int i;

	for(i=0; i<100; i++)
	   { wait e;
	     x++;
	    }
	}
};

behavior B(out event e)
{
	void main(void)
	{
	int i;

	for(i=0; i<100; i++)
	   { notify e;
	     waitfor 1;
	    }
	}
};

behavior Main
{
	int	x = 0;
	event	e;
	A	a(e, x);
	B	b(e);

	int main(void)
	{
	puts("waitfor6: Starting...");

	par {	a.main();
		b.main();
		};
	assert(x == 100);
	assert(now() == 100);

	par {	b.main();
		a.main();
		};
	assert(x == 200);
	assert(now() == 200);

	puts("waitfor6: Done.");
	return(0);
	}
};

// EOF
