// div.sc

// Test for division operation
#include <sim.sh>

#include <stdio.h>
#include <stdlib.h>
#include <time.h>


behavior Main(void)
{
  int main(int argc, char* argv[])
  {
    char buf1[64], buf2[64], buf3[64], buf4[64];
    int count;
    long long n,d,r,q;
    bit[170:0] nv;
    bit[63:0]  dv;
    bit[170:0] qv;
    bit[170:0] rv;

    srand(time(0));

    if (argc == 2) {
      count = atoi(argv[1]);
    } else {
      if (argc <= 1) count = 10; else count = 1;
    }

    for (; count > 0; count--) 
    {
      if (argc >= 3) {
	n = atol(argv[1]);
	d = atol(argv[2]);
      } else {
	n = ((long long)rand() << 48) | ((unsigned long long)rand() << 32) |
	    ((unsigned long long)rand() << 16) | (unsigned long)rand();
	d = ((long long)rand() << 48) | ((unsigned long long)rand() << 32) |
	    ((unsigned long long)rand() << 16) | (unsigned long)rand();
      }

      r  = n % d;
      q  = n / d;
      
      printf("Performing %s / %s = %s rem %s\n", 
	     ll2str(10, &buf1[63], n), ll2str(10, &buf2[63], d), 
	     ll2str(10, &buf3[63], q), ll2str(10, &buf4[63], r));

      dv = d;
      nv = n; 

      qv = (nv / dv);
      rv = (nv % dv);

      if ((rv != r) || (qv != q)) {
	printf("### Mismatch:\n");
	printf("N   = %s\n", bit2str(10, &buf1[63], nv));
	printf("D   = %s\n", bit2str(10, &buf2[63], dv));
	printf("N/D = %s\n", bit2str(10, &buf3[63], qv));
	printf("N%%D = %s\n", bit2str(10, &buf4[63], rv));
	return 1;
      }
    }
    return 0;
  }
};



