/************************************************************************/
/* Alignment.cc: utility to determine alignment of structures, etc.	*/
/************************************************************************/
/* Author: Rainer Doemer						*/
/************************************************************************/

/* last update: 11/19/01 */

/* modifications: (most recent first)
 *
 * 11/19/01 RD	additional checks for support of gcc 3.0[.2]
 * 11/14/01 RD	introduced this header (last update was 04/06/01)
 */

#include <stdio.h>
#include <assert.h>


	/* allow (limited) compilation with gcc 2.7.2 */

#if (__GNUC__ == 2) && (__GNUC_MINOR__ < 8)
#define EXCLUDE_TEMPLATES
#else
#define INCLUDE_TEMPLATES
#endif

#ifdef EXCLUDE_TEMPLATES
#include <sys/bit.h>
#else
#ifndef HAVE_LLONG
#include <longlong.h>
#endif /* HAVE_LLONG */
#include <bit.h>
#include <specc.h>
#endif

#define ABS(a)		((a) > (0) ? (a) : (-(a)))
#define MIN(a, b)	((a) < (b) ? (a) : (b))
#define MAX(a, b)	((a) > (b) ? (a) : (b))


struct BoolStruct
{
char x1;
bool x2;
};

struct CharStruct
{
char x1;
char x2;
};

struct ShortStruct
{
char x1;
short x2;
};

struct IntStruct
{
char x1;
int x2;
};

struct LongStruct
{
char x1;
long x2;
};

#ifdef HAVE_LLONG
struct LongLongStruct
{
char x1;
long long x2;
};
#else /* not HAVE_LLONG */
struct LongLongStruct
{
char x1;
_longlong<false> x2;
};
#endif /* HAVE_LLONG */

struct BitVecStruct
{
char x1;
#ifdef EXCLUDE_TEMPLATES
_bitrep x2;
#else
bit<1,false> x2;
#endif
};

#ifdef INCLUDE_TEMPLATES
template class bit<1,false>;		/* explicit instantiation! */
#ifndef HAVE_LLONG
template class _longlong<false>;	/* explicit instantiation! */
#endif /* HAVE_LLONG */
#endif

struct FloatStruct
{
char x1;
float x2;
};

struct DoubleStruct
{
char x1;
double x2;
};

struct LongDoubleStruct
{
char x1;
long double x2;
};

struct PointerStruct
{
char x1;
void* x2;
};

struct StructStruct
{
char x1;
struct {char c;} x2;
};

struct UnionStruct
{
char x1;
union {char c;} x2;
};

struct OneBit {int b:1;};	// ANSI C++ forbids defining types within sizeof

struct BitfieldStruct
{
int	b1 : sizeof(struct OneBit) * 8 - 1;	/* eg. 15 */
int	b2 : 2;					/*      2 */
int	b3 : sizeof(struct OneBit) * 8 - 1;	/* eg. 15 */
};


#ifdef INCLUDE_TEMPLATES
class Empty
{
// nothing in here
};

class I
{
public:
	virtual int Method1(void ) = 0;
	virtual int Method2(void ) = 0;
};
class I2
{
public:
	virtual int Method3(void ) = 0;
};

class C0 : public _specc::channel
{
public:
	C0(void);
	virtual ~C0(void);
};
C0::C0(void) {}
C0::~C0(void) {}

class C : public _specc::channel, public I, public I2
{
public:
	C(void);
	virtual ~C(void);
	int Method1(void );
	int Method2(void );
	int Method3(void );
};
C::C(void) {}
C::~C(void) {}
int C::Method1(void) {return 42;}
int C::Method2(void) {return 42;}
int C::Method3(void) {return 42;}

class B0 : public _specc::behavior
{
public:
	B0(void);
	virtual ~B0(void);
	void main(void );
};
B0::B0(void) {}
B0::~B0(void) {}
void B0::main(void) {}

class B : public _specc::behavior, public I
{
public:
	int (&p1);
	B(int (&p1));
	virtual ~B(void);
	int LocalMethod(void );
	int Method1(void );
	int Method2(void );
	void main(void );
	char LocalVariable;
	C ChannelInst1;
	C ChannelInst2;
};
B::B(int (&p1)): p1(p1) {}
B::~B(void) {}
int B::Method1(void) {return 42;}
int B::Method2(void) {return 42;}
void B::main(void) {}

struct ChannelStruct
{
char x1;
C0 x2;
};

struct BehaviorStruct
{
char x1;
B0 x2;
};

struct EventStruct
{
char x1;
_specc::event x2;
};

int		x;
C		c1;
B		b1(x);
EventStruct	es;
#endif /* INCLUDE_TEMPLATES */


struct BoolStruct	bs;
struct CharStruct	cs;
struct ShortStruct	ss;
struct IntStruct	is;
struct LongStruct	ls;
struct LongLongStruct	lls;
struct BitVecStruct	bvs;
struct FloatStruct	fs;
struct DoubleStruct	ds;
struct LongDoubleStruct	lds;
struct PointerStruct	ps;
struct StructStruct	ts;
struct UnionStruct	us;
struct BitfieldStruct	bfs;
#ifdef INCLUDE_TEMPLATES
struct ChannelStruct	chnls;
struct BehaviorStruct	bhvrs;
#endif /* INCLUDE_TEMPLATES */


int main(void)
{
int		d, m, dp;
unsigned int	sp;
#ifdef INCLUDE_TEMPLATES
int		db, dc, di;
unsigned int	sb, sc, si, s;
#endif /* INCLUDE_TEMPLATES */


printf("/*** Alignment.h: Data Alignment in Structures ***/\n\n");
printf("/* (automatically generated by 'Alignment') */\n\n");

printf("#ifndef SIR_ALIGNMENT_H\n");
printf("#define SIR_ALIGNMENT_H\n\n");

assert(sizeof(char) == 1);

d = ((unsigned long)&bs.x1) - ((unsigned long)&bs.x2);
m = ABS(d);
printf("#define SIR_ALIGN_BOOL\t\t%d\n", ABS(d));

d = ((unsigned long)&cs.x1) - ((unsigned long)&cs.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_CHAR\t\t%d\n", ABS(d));

d = ((unsigned long)&ss.x1) - ((unsigned long)&ss.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_SHORT\t\t%d\n", ABS(d));

d = ((unsigned long)&is.x1) - ((unsigned long)&is.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_INT\t\t%d\n", ABS(d));

d = ((unsigned long)&ls.x1) - ((unsigned long)&ls.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_LONG\t\t%d\n", ABS(d));

d = ((unsigned long)&lls.x1) - ((unsigned long)&lls.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_LONGLONG\t%d\n", ABS(d));

d = ((unsigned long)&bvs.x1) - ((unsigned long)&bvs.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_BITVECTOR\t%d\n", ABS(d));

d = ((unsigned long)&fs.x1) - ((unsigned long)&fs.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_FLOAT\t\t%d\n", ABS(d));

d = ((unsigned long)&ds.x1) - ((unsigned long)&ds.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_DOUBLE\t%d\n", ABS(d));

d = ((unsigned long)&lds.x1) - ((unsigned long)&lds.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_LONGDOUBLE\t%d\n", ABS(d));

sp = sizeof(void*);
dp = d = ((unsigned long)&ps.x1) - ((unsigned long)&ps.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_POINTER\t%d\n", ABS(d));

d = ((unsigned long)&ts.x1) - ((unsigned long)&ts.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_STRUCT\t%d\n", ABS(d));

d = ((unsigned long)&us.x1) - ((unsigned long)&us.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_UNION\t\t%d\n", ABS(d));

if (sizeof(bfs) == 2 * sizeof(struct OneBit))
   { printf("\n#define SIR_BITFIELD_PACKING_TIGHT\n");
    } /* fi */
else
   { if (sizeof(bfs) == 3 * sizeof(struct OneBit))
	{ printf("\n#define SIR_BITFIELD_PACKING_LOOSE\n");
	 } /* fi */
     else
	{ printf("\n#define SIR_BITFIELD_PACKING_UNKNOWN\n");
	 } /* esle */
    } /* esle */

#ifdef INCLUDE_TEMPLATES

sb = s = sizeof(_specc::behavior);
printf("\n#define SIR_SIZE_OF_BHVR_BASE\t%d\n", s);
assert(sizeof(_specc::behavior) > sizeof(Empty)); // vptr. in base class

sc = s = sizeof(_specc::channel);
printf("#define SIR_SIZE_OF_CHNL_BASE\t%d\n", s);
assert(sizeof(_specc::channel) > sizeof(Empty)); // vptr. in base class

si = s = sizeof(I);
assert(sizeof(I) == sizeof(I2));
printf("#define SIR_SIZE_OF_INTERFACE\t%d\n", s);

s = sizeof(_specc::event);
printf("#define SIR_SIZE_OF_EVENT\t%d\n", s);

db = d = ((unsigned long)&bhvrs.x1) - ((unsigned long)&bhvrs.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_BHVR_BASE\t%d\n", ABS(d));

dc = d = ((unsigned long)&chnls.x1) - ((unsigned long)&chnls.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_CHNL_BASE\t%d\n", ABS(d));

assert(sizeof(I) == sizeof(void*));
di = d = ((unsigned long)&ps.x1) - ((unsigned long)&ps.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_INTERFACE\t%d\n", ABS(d));

d = ((unsigned long)&es.x1) - ((unsigned long)&es.x2);
m = MAX(ABS(d), m);
printf("#define SIR_ALIGN_EVENT\t\t%d\n", ABS(d));

s =	sc;	/* verify sizeof(c1) */
s +=	(s % ABS(di)) + si;
s +=	(s % ABS(di)) + si;
assert(sizeof(c1) == s);
s =	sb;	/* verify layout of b1 */
s +=	(s % ABS(di)) + si;
s +=	(s % ABS(dp)) + sp;
assert((unsigned long)&b1 + s == (unsigned long)&b1.LocalVariable);
assert((unsigned long)&b1 < (unsigned long)&b1.LocalVariable);
assert((unsigned long)&b1.LocalVariable < (unsigned long)&b1.ChannelInst1);
assert((unsigned long)&b1.ChannelInst1 < (unsigned long)&b1.ChannelInst2);

#else /* EXCLUDE_TEMPLATES */

	/* just put some guessed values */
printf("\n#define SIR_SIZE_OF_BHVR_BASE\t%d\n", sizeof(void*));
printf("#define SIR_SIZE_OF_CHNL_BASE\t%d\n", sizeof(void*));
printf("#define SIR_SIZE_OF_INTERFACE\t%d\n", sizeof(void*));
printf("#define SIR_SIZE_OF_EVENT\t%d\n", sizeof(void*));
printf("#define SIR_ALIGN_BHVR_BASE\t%d\n", sizeof(void*));
printf("#define SIR_ALIGN_CHNL_BASE\t%d\n", sizeof(void*));
printf("#define SIR_ALIGN_INTERFACE\t%d\n", sizeof(void*));
printf("#define SIR_ALIGN_EVENT\t\t%d\n", sizeof(void*));
m = MAX((int)sizeof(void*), m);

#endif /* INCLUDE_TEMPLATES */

printf("\n#define SIR_ALIGN_MAX\t\t%d\n", m);

printf("\n#endif /* SIR_ALIGNMENT_H */\n");

printf("\n/* EOF */\n");

return(0);

} /* end of main */

/* EOF */
