// try26.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior Try(in event e)
{
	void main(void)
	{
	wait e;
	}
};

behavior Interrupt(inout int x)
{
	void main(void)
	{
	x++;
	}
};

behavior Exception(inout int x, in event e)
{
	Try		t(e);
	Interrupt	i(x);

	void main(void)
	{
	try {	t.main();
		}
		interrupt e
		    {	i.main();
			};
	}
};

behavior Trigger(in int x, out event e)
{
	void main(void)
	{
	waitfor 3;
	notify e;
	waitfor 3;
	notify e;
	waitfor 3;

	assert(x == 2);
	assert(now() == 9);
	puts("try26: Expecting deadlock... (Done.)");
	}
};

behavior Main
{
	event		e1;
	int		x = 0;

	Exception	e(x, e1);
	Trigger		t(x, e1);

	int main(void)
	{
	puts("try26: Starting...");

	par {	e.main();
		t.main();
		}

	assert(false);
	return(0);
	}
};

// EOF
