/************************************************************************/
/* IntRep/Node.h: SpecC Internal Representation, Node Base Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 09/24/97 */
/************************************************************************/

/* last update: 10/16/01 */

/* modifications: (most recent first)
 *
 * 10/16/01 RD	added SIR_Node::CmpLineInfo() for generating ordered code
 * 10/16/01 RD	created modifications list (last update was 04/13/99)
 */

#ifndef INTREP_NODE_H
#define INTREP_NODE_H


#include "Global.h"
#include "IntRep/FileInfo.h"


/*** constants and macros ***********************************************/


	/* none */


/*** enumeration types **************************************************/


	/* none */


/*** type definitions ***************************************************/


typedef class SIR_Node			sir_node;
typedef void *				sir_node_marg;
typedef ERROR (SIR_Node::*sir_node_mptr)(void*);


/*** class declarations *************************************************/


	/****************/
	/*** SIR_Node ***/
	/****************/


class SIR_Node			/* base class for all nodes */
{
public:
sir_lineinfo	*LineInfo;	/* line information (NULL if unknown) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Node(void);			/* constructor #1 (nodes without lineinfo) */

SIR_Node(			/* constructor #2 (nodes with lineinfo) */
	unsigned int	Line,
	sir_fileinfo	*FileInfo);

SIR_Node(			/* constructor #3 (duplicator) */
	sir_node	*Original);

~SIR_Node(void);		/* destructor */


ERROR UnaliasFilePointer(	/* unalias the file info (if any) */
	sir_node_marg	/* Unused */);

ERROR MarkUsedFiles(		/* marks the file entry used here */
	sir_node_marg	/* Unused */);

ERROR Strip(			/* removes the source information #1 */
	sir_node_marg	/* Unused */);	/* (iterator version) */


void Strip(void);		/* removes the source information #2 */

void UpdateLineInfo(		/* update the source info (if any) */
	unsigned int	Line,	/* (keeps old info if no new is specified) */
	sir_fileinfo	*FileInfo);

void SetLineInfo(		/* sets the same source info */
	sir_node	*Node);

static int CmpLineInfo(		/* compare two line infos (like strcmp()) */
	sir_node	*Node1,
	sir_node	*Node2);
};


#endif /* INTREP_NODE_H */

/* EOF IntRep/Node.h */
