/************************************************************************/
/* IntRep/Extern.h: SpecC Internal Repr., Interfaces to ext. Modules	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 04/22/98 */
/************************************************************************/

/* last update: 09/07/01 */

/* modifications: (most recent first)
 *
 * 09/07/01 RD	bug fix: definitions adjusted for modified 'piped' template
 * 05/30/01 RD	removed code not needed for the SCRC
 * 05/23/01 RD	added SIR_CXX_MAIN_INST_NAME
 * 05/21/01 RD	added support for (native, non-native) array assignment
 * 04/30/01 RD	adjusted SIR_BIT_SLICE_NAME to changes in bitlib
 * 04/25/01 RD	added shadow class names for use inside 'union's
 * 04/25/01 RD	made SIR_CXX_TIME_TYPE dependent on HAVE_LLONG
 * 04/18/01 RD	extended longlong library interface
 * 04/16/01 RD	added longlong library interface
 * 04/06/01 RD	changed time type to 'unsigned long long'
 * 04/05/01 RD	added constants for new 'pipe' construct
 * 02/14/01 RD	added definitions for SIR_CXX_OPEN_PORT_NAME and
 *		SIR_CXX_CONST_PORT_NAME
 * 02/14/01 RD	created modifications list (last update was 03/23/99)
 */


#ifndef INTREP_EXTERN_H
#define INTREP_EXTERN_H


/*** constants and macros ***********************************************/


	/* simulation library interface */

#define SIR_SIM_HEADER_NAME	"specc.h"
#define SIR_SIM_CLASS_NAME	"_specc"
#define SIR_SIM_SYMBOL_PREFIX	SIR_SIM_CLASS_NAME "::"
#define SIR_SIM_EVENT_NAME	SIR_SIM_SYMBOL_PREFIX "event"
#define SIR_SIM_BEHAVIOR_NAME	SIR_SIM_SYMBOL_PREFIX "behavior"
#define SIR_SIM_CHANNEL_NAME	SIR_SIM_SYMBOL_PREFIX "channel"
#define SIR_SIM_FORK_NAME	SIR_SIM_SYMBOL_PREFIX "fork"
#define SIR_SIM_INIT		SIR_SIM_SYMBOL_PREFIX "start"
#define SIR_SIM_EXIT		SIR_SIM_SYMBOL_PREFIX "end"
#define SIR_SIM_PAR_NAME	SIR_SIM_SYMBOL_PREFIX "par"
#define SIR_SIM_PIPE_NAME	SIR_SIM_SYMBOL_PREFIX "pipe"
#define SIR_SIM_PIPED_NAME	"piped"
#define SIR_SIM_PIPED_IN_ACCESS(s)	".Value[0]"
#define SIR_SIM_PIPED_OUT_ACCESS(s)	".Value[%d]", s
#define SIR_SIM_EXCEPTION_NAME	SIR_SIM_SYMBOL_PREFIX "tryTrapInterrupt"
#define SIR_SIM_TRY_BLOCK	SIR_SIM_SYMBOL_PREFIX "try_block"
#define SIR_SIM_EXCEPT_BLOCK	SIR_SIM_SYMBOL_PREFIX "exception_block"
#define SIR_SIM_TRAP_FLAG	"true"
#define SIR_SIM_INTERRUPT_FLAG	"false"
#define SIR_SIM_WAITFOR_NAME	SIR_SIM_SYMBOL_PREFIX "waitfor"
#define SIR_SIM_WAIT_NAME	SIR_SIM_SYMBOL_PREFIX "wait"
#define SIR_SIM_NOTIFY_NAME	SIR_SIM_SYMBOL_PREFIX "notify"
#define SIR_SIM_NOTIFYONE_NAME	SIR_SIM_SYMBOL_PREFIX "notifyone"
#define SIR_SIM_CURR_TIME_NAME	SIR_SIM_SYMBOL_PREFIX "getCurrentTime()"
#define SIR_SIM_ABORT		SIR_SIM_SYMBOL_PREFIX "abort"


	/* longlong library interface */

#define SIR_LLONG_HEADER_NAME	"longlong.h"
#ifndef HAVE_LLONG
#define SIR_LLONG_CLASS_NAME	"_longlong"
#define SIR_LLONG_SHADOW_NAME	"_longlong_"
#define SIR_LLONG_SIGNED_FLAG	"false"
#define SIR_LLONG_UNSIGNED_FLAG	"true"
#define SIR_LLONG2_BOOL_NAME	"test"
#define SIR_LLONG2_INT_NAME	"toInt"
#define SIR_LLONG2_UINT_NAME	"toUInt"
#define SIR_LLONG2_LONG_NAME	"toLong"
#define SIR_LLONG2_ULONG_NAME	"toULong"
#define SIR_LLONG2_DOUBLE_NAME	"toDouble"
#define SIR_LLONG2_LDOUBLE_NAME	"toLDouble"
#endif /* !HAVE_LLONG */

#ifdef HAVE_LLONG
#define SIR_LLONG2B(v)		v
#define SIR_LLONG2I(v)		v
#define SIR_LLONG2UI(v)		v
#define SIR_LLONG2L(v)		v
#define SIR_LLONG2UL(v)		v
#define SIR_LLONG2D(v)		v
#define SIR_LLONG2LD(v)		v
#else /* !HAVE_LLONG */
#define SIR_LLONG2B(v)		(v.test())
#define SIR_LLONG2I(v)		(v.toInt())
#define SIR_LLONG2UI(v)		(v.toUInt())
#define SIR_LLONG2L(v)		(v.toLong())
#define SIR_LLONG2UL(v)		(v.toULong())
#define SIR_LLONG2D(v)		(v.toDouble())
#define SIR_LLONG2LD(v)		(v.toLDouble())
#endif /* HAVE_LLONG */


	/* bitvector library interface */

#define SIR_BIT_HEADER_NAME	"bit.h"
#define SIR_BIT_CLASS_NAME	"bit"
#define SIR_BIT_SHADOW_NAME	"_bit_"
#define SIR_BIT_BASE_CLASS_NAME	"_bit"
#define SIR_BIT_BUS_CLASS_NAME	"_bitbus"
#define SIR_BIT_BUS_SLICE_NAME	"bus_slice"
#define SIR_BIT_BUS_CONCAT_NAME	"concat"
#define SIR_BIT_SIGNED		false
#define SIR_BIT_UNSIGNED	true
#define SIR_BIT_SIGNED_FLAG	"false"
#define SIR_BIT_UNSIGNED_FLAG	"true"
#define SIR_BIT_SYMBOL_PREFIX	SIR_BIT_BASE_CLASS_NAME "::"
#define SIR_BIT_CONCAT_NAME	SIR_BIT_SYMBOL_PREFIX "concat"
#define SIR_BIT_SLICE_NAME	""
#define SIR_BIT_LENGTH_NAME	"_BITLEN"
#define SIR_BIT_2_BOOL_NAME	"test"
#define SIR_BIT_2_INT_NAME	"toInt"
#define SIR_BIT_2_UINT_NAME	"toUInt"
#define SIR_BIT_2_LONG_NAME	"toLong"
#define SIR_BIT_2_ULONG_NAME	"toULong"
#define SIR_BIT_2_LLONG_NAME	"toLLong"
#define SIR_BIT_2_ULLONG_NAME	"toULLong"
#define SIR_BIT_2_DOUBLE_NAME	"toDouble"
#define SIR_BIT_2_LDOUBLE_NAME	"toLDouble"
#define SIR_BIT_DIRECTLY_MAPPABLE(p_l, p_r, p_s, b_l, b_r, b_s)	\
	(  ((p_s) == (b_s))					\
	 &&((ABS((p_l)-(p_r))+1) == (ABS((b_l)-(b_r))+1)) )
#define SIR_BIT_VEC_ADD_SIZE	4	/* one addl. vtab pointer */
#define SIR_BIT_VEC_ADD_ALIGN	SIR_ALIGN_POINTER
#define SIR_BIT_BUS_ADD_SIZE	8	/* one addl. vtab and another pointer */
#define SIR_BIT_BUS_ADD_ALIGN	SIR_ALIGN_POINTER


	/* translator to C++ interface */

#define SIR_CXX_NEW_NAME_PREFIX	"_scc_"
#define SIR_CXX_MAIN_INST_NAME	SIR_CXX_NEW_NAME_PREFIX "main"
#define SIR_CXX_MAIN_ARG_NAME	SIR_CXX_NEW_NAME_PREFIX "main_arg_%d"
#define SIR_CXX_MAIN_RET_NAME	SIR_CXX_NEW_NAME_PREFIX "main_return"
#define SIR_CXX_STATE_PREFIX	SIR_CXX_NEW_NAME_PREFIX "state_"
#define SIR_CXX_STATE_VARIABLE	SIR_CXX_NEW_NAME_PREFIX "next_state"
#define SIR_CXX_FORK_VARIABLE	SIR_CXX_NEW_NAME_PREFIX "forked_"
#define SIR_CXX_TRY_VARIABLE	SIR_CXX_NEW_NAME_PREFIX "try_"
#define SIR_CXX_EXCEPT_VARIABLE	SIR_CXX_NEW_NAME_PREFIX "exception_"
#define SIR_CXX_SLICED_BUS_NAME	SIR_CXX_NEW_NAME_PREFIX "bus_%d"
#define SIR_CXX_OPEN_PORT_NAME	SIR_CXX_NEW_NAME_PREFIX "open_port_%d"
#define SIR_CXX_CONST_PORT_NAME	SIR_CXX_NEW_NAME_PREFIX "const_port_%d"
#define SIR_CXX_DUMMY_PORT_NAME	SIR_CXX_NEW_NAME_PREFIX "port_%d"
#ifdef HAVE_LLONG
#define SIR_CXX_TIME_TYPE	"unsigned long long"
#else /* !HAVE_LLONG */
#define SIR_CXX_TIME_TYPE	SIR_LLONG_CLASS_NAME	\
				"<" SIR_LLONG_UNSIGNED_FLAG ">"
#endif /* HAVE_LLONG */
#define SIR_CXX_TIMESTAMP_PREFX	SIR_CXX_NEW_NAME_PREFIX "time_stamp_"
#define SIR_CXX_RANGE_NAME	SIR_CXX_NEW_NAME_PREFIX "range_check"
#define SIR_CXX_FIRST_NAME	SIR_CXX_NEW_NAME_PREFIX "first"
#define SIR_CXX_LAST_NAME	SIR_CXX_NEW_NAME_PREFIX "last"
#define SIR_CXX_INDEX_NAME	SIR_CXX_NEW_NAME_PREFIX "index_"


#endif /* INTREP_EXTERN_H */

/* EOF IntRep/Extern.h */
