// LongLong.sc

long long llf(long long x)
{
	return(x * x);
}

unsigned long long ullf(unsigned long long x)
{
	return(x * x);
}

bit[42] bitf(bit[42] x)
{
	return(x * x);
}

unsigned bit[42] ubitf(unsigned bit[42] x)
{
	return(x * x);
}

behavior Shadow
{
	void main(void)
	{
		union { long long	ll;
			int		i; } x;
		union { unsigned long long ull;
			int		i; } y;

		x.ll = 42;
		y.ull = 42;

		x.ll += 33;
		y.ull += 44;

		x.ll += y.ull;
		y.ull += x.ll;

		x.ll = x.ll * x.ll;
		y.ull = y.ull * y.ull;
		x.ll = x.ll * y.ull;
		y.ull = y.ull * x.ll;

		x.ll = x.ll | x.ll;
		y.ull = y.ull | y.ull;
		x.ll = x.ll | y.ull;
		y.ull = y.ull | x.ll;

		x.ll -= llf(x.ll);
		y.ull -= ullf(y.ull);
		y.ull -= llf(x.ll);
		x.ll -= ullf(y.ull);
		x.ll -= ullf(x.ll);
		y.ull -= llf(y.ull);
		y.ull -= ullf(x.ll);
		x.ll -= llf(y.ull);

		x.ll = x.ll + 'c' + (short)42 + 42 + 42ll;
		x.ll = x.ll + 'c' + (unsigned short)42 + 42u + 42ull;
		y.ull = y.ull + 'c' + (short)42 + 42 + 42ll;
		y.ull = y.ull + 'c' + (unsigned short)42 + 42u + 42ull;
	}
};

behavior LLvsBit
{
	void main(void)
	{
		long long	ll;
		unsigned bit[42] ubit;

		ll = 42;
		ubit = 42;

		ll += 33;
		ubit += 44;

		ll += ubit;
		ubit += ll;

		ll = ll * ll;
		ubit = ubit * ubit;
		ll = ll * ubit;
		ubit = ubit * ll;

		ll = ll | ll;
		ubit = ubit | ubit;
		ll = ll | ubit;
		ubit = ubit | ll;

		ll -= llf(ll);
		ubit -= ubitf(ubit);
		ubit -= llf(ll);
		ll -= ubitf(ubit);
		ll -= ubitf(ll);
		ubit -= llf(ubit);
		ubit -= ubitf(ll);
		ll -= llf(ubit);

		ll = ll + 'c' + (short)42 + 42 + 42ll;
		ll = ll + 'c' + (unsigned short)42 + 42u + 11110000ub;
		ubit = ubit + 'c' + (short)42 + 42 + 42ll;
		ubit = ubit + 'c' + (unsigned short)42 + 42u + 11110000ub;
	}
};

behavior LLvsBit_S
{
	void main(void)
	{
		union { long long	ll;
			int		i; } x;
		union { unsigned bit[42] ubit;
			int		i; } y;

		x.ll = 42;
		y.ubit = 42;

		x.ll += 33;
		y.ubit += 44;

		x.ll += y.ubit;
		y.ubit += x.ll;

		x.ll = x.ll * x.ll;
		y.ubit = y.ubit * y.ubit;
		x.ll = x.ll * y.ubit;
		y.ubit = y.ubit * x.ll;

		x.ll = x.ll | x.ll;
		y.ubit = y.ubit | y.ubit;
		x.ll = x.ll | y.ubit;
		y.ubit = y.ubit | x.ll;

		x.ll -= llf(x.ll);
		y.ubit -= ubitf(y.ubit);
		y.ubit -= llf(x.ll);
		x.ll -= ubitf(y.ubit);
		x.ll -= ubitf(x.ll);
		y.ubit -= llf(y.ubit);
		y.ubit -= ubitf(x.ll);
		x.ll -= llf(y.ubit);

		x.ll = x.ll + 'c' + (short)42 + 42 + 42ll;
		x.ll = x.ll + 'c' + (unsigned short)42 + 42u + 11110000ub;
		y.ubit = y.ubit + 'c' + (short)42 + 42 + 42ll;
		y.ubit = y.ubit + 'c' + (unsigned short)42 + 42u + 11110000ub;
	}
};

behavior Main
{
	Shadow		S;
	LLvsBit		B;
	LLvsBit_S	BS;

	int main(void)
	{
		long long		ll;
		unsigned long long	ull;

		ll = 42;
		ull = 42;

		ll += 33;
		ull += 44;

		ll += ull;
		ull += ll;

		ll = ll * ll;
		ull = ull * ull;
		ll = ll * ull;
		ull = ull * ll;

		ll = ll | ll;
		ull = ull | ull;
		ll = ll | ull;
		ull = ull | ll;

		ll -= llf(ll);
		ull -= ullf(ull);
		ull -= llf(ll);
		ll -= ullf(ull);
		ll -= ullf(ll);
		ull -= llf(ull);
		ull -= ullf(ll);
		ll -= llf(ull);

		ll = ll + 'c' + (short)42 + 42 + 42ll;
		ll = ll + 'c' + (unsigned short)42 + 42u + 42ull;
		ull = ull + 'c' + (short)42 + 42 + 42ll;
		ull = ull + 'c' + (unsigned short)42 + 42u + 42ull;

		S.main();
		B.main();
		BS.main();

		return(0);
	}
};

// EOF

