// try8.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior Try
{
	void main(void)
	{
	waitfor 10;
	}
};

behavior TrapA(inout int x)
{
	void main(void)
	{
	x++;
	}
};

behavior TrapB(inout int y)
{
	void main(void)
	{
	y++;
	}
};

behavior InterruptA(inout int x)
{
	void main(void)
	{
	x++;
	}
};

behavior InterruptB(inout int y)
{
	void main(void)
	{
	y++;
	}
};

behavior Exception(inout int x, inout int y,
		in event e1, in event e2, in event e3, in event e4)
{
	Try		t;
	TrapA		ta(x);
	TrapB		tb(y);
	InterruptA	ia(x);
	InterruptB	ib(y);

	void main(void)
	{
	try {	t.main();
		}
		trap e1
		    {	ta.main();
			}
		trap e1, e2
		    {	tb.main();
			}
		interrupt e1, e2, e3
		    {	ia.main();
			}
		interrupt e1, e2, e3, e4
		    {	ib.main();
			};
	}
};

behavior Trigger257(out event e)
{
	void main(void)
	{
	waitfor 2;
	notify e;
	waitfor 3;
	notify e;
	waitfor 2;
	notify e;
	waitfor 1;
	}
};

behavior Trigger356(out event e)
{
	void main(void)
	{
	waitfor 3;
	notify e;
	waitfor 2;
	notify e;
	waitfor 1;
	notify e;
	waitfor 1;
	}
};

behavior Main
{
	event		e1, e2, e3, e4;
	int		x = 0;
	int		y = 0;

	Exception	e(x, y, e1, e2, e3, e4);
	Trigger257	t1_257(e1),
			t2_257(e2),
			t3_257(e3);
	Trigger356	t2_356(e2),
			t3_356(e3),
			t4_356(e4);

	int main(void)
	{
	puts("try8: Starting...");

	par {	e.main();
		t1_257.main();
		t2_257.main();
		}
	assert(x == 1);
	assert(y == 0);
	assert(now() == 8);

	par {	e.main();
		t3_257.main();
		t2_356.main();
		}
	assert(x == 2);
	assert(y == 1);
	assert(now() == 16);

	par {	e.main();
		t3_356.main();
		t4_356.main();
		}
	assert(x == 5);
	assert(y == 1);
	assert(now() == 26);

	par {	e.main();
		t2_257.main();
		t2_356.main();
		}
	assert(x == 5);
	assert(y == 2);
	assert(now() == 34);

	par {	e.main();
		t3_257.main();
		t3_356.main();
		}
	assert(x == 10);
	assert(y == 2);
	assert(now() == 44);

	puts("try8: Done.");
	return(0);
	}
};

// EOF
