// ============================================================================
// longlong.h: "long long" data type support
// ============================================================================
// 
//
// 05/24/01 <gerstl>	Initial version
//
// ----------------------------------------------------------------------------


#ifndef __LONGLONG
#define __LONGLONG




  



/* ------------------------------------------------------------------------- */
/* Native (built-in) long long data type */


#include <limits.h>


// Native long long version of library
#undef  HAVE_LLONG  
#define HAVE_LLONG  

  
// Provide constants
#ifndef LONG_LONG_MAX
#ifdef LLONG_MAX
#define LONG_LONG_MAX     LLONG_MAX    // SOLARIS et al.
#elif defined(QUAD_MAX)
#define LONG_LONG_MAX     QUAD_MAX     // NETBSD
#else
#define LONG_LONG_MAX     0x7fffffffffffffffLL
#endif
#endif
  
#ifndef ULONG_LONG_MAX
#ifdef ULLONG_MAX
#define ULONG_LONG_MAX    ULLONG_MAX   // SOLARIS et al.
#elif defined(UQUAD_MAX)
#define ULONG_LONG_MAX    UQUAD_MAX    // NETBSD
#else
#define ULONG_LONG_MAX    0xffffffffffffffffULL
#endif
#endif

#ifndef LLONG_MAX
#define LLONG_MAX         LONG_LONG_MAX
#endif

#ifndef ULLONG_MAX
#define ULLONG_MAX        ULONG_LONG_MAX
#endif

  
  
/* ---  Global functions --- */
  
extern "C" {
  
// conversion of long long to string (see sim.sh)  
char *ll2str(unsigned int base, char *endptr, long long ll);
char *ull2str(unsigned int base, char *endptr, unsigned long long ull);

// conversion of string to long long (see sim.sh)
long long str2ll(unsigned int base, const char* str);
unsigned long long str2ull(unsigned int base, const char* str);
    
}




#endif

  

