// piped2.sc

#include <stdio.h>
#include <assert.h>

behavior A(out int p0, out int p1, out int p2)
{
	int	Count = 0;

	void main(void)
	{
	Count++;
	p0 = Count;
	waitfor 5;
	p1 = Count;
	p2 = Count;
	}
};

behavior B(in int p0, in int p1, out int p2)
{
	int	Count = 0;

	void main(void)
	{
	Count++;
	waitfor 1;
	if ((Count == 3) || (Count == 6))
	   { assert(p0 == Count);
	    }
	else
	   { assert(p0 == Count+1);
	    }
	assert(p1 == Count);
	waitfor 4;
	p2 = Count;
	}
};

behavior C(in int p0, in int p1, in int p2)
{
	int	Count = 0;

	void main(void)
	{
	Count++;
	waitfor 1;
	if ((Count == 3) || (Count == 6))
	   { assert(p0 == Count);
	    }
	else if ((Count == 2) || (Count == 5))
	   { assert(p0 == Count+1);
	    }
	else
	   { assert(p0 == Count+2);
	    }
	assert(p1 == Count);
	assert(p2 == Count);
	}
};

behavior Main
{
	int		p0 = 0;
	piped int	p1a,
			p1b;
	piped piped int	p2;
	int		i;

	A	a(p0, p1a, p2);
	B	b(p0, p1a, p1b);
	C	c(p0, p1b, p2);

	int main(void)
	{
	puts("piped2: Starting...");

	pipe(i=0; i<3; i++)
	   {	a.main();
		b.main();
		c.main();
		};
	assert(p0 == 3);
	assert((p1a == 3) && (p1b == 3));
	assert(p2 == 3);

	pipe(i=0; i<3; i++)
	   {	a.main();
		b.main();
		c.main();
		};
	assert(p0 == 6);
	assert((p1a == 6) && (p1b == 6));
	assert(p2 == 6);

	puts("piped2: Done.");
	return(0);
	}
};

// EOF
