/************************************************************************/
/* IntRep.cc: SpecC Internal Representation, Test file			*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 09/24/97 */
/************************************************************************/

/* last update: 05/29/01 */

/* modifications: (most recent first)
 *
 * 05/29/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 04/19/01 RD	fixed a bug in test 1 (TypeBitVec7)
 * 04/18/01 RD	adjusted use of non-native 'long long' types
 * 04/16/01 RD	added support for non-native 'long long' type;
 *		changed use of 'long long int' to TIME type
 * 04/16/01 RD	started this header (last update was 06/27/99)
 */

#include "IntRep.h"

#include <stdlib.h>


/*** constants and macros ***********************************************/


#ifdef DEBUG
#ifndef SIR_DEBUG
#define SIR_DEBUG
#endif /* SIR_DEBUG */
#endif /* DEBUG */

// #define SIR_PERFORM_TEST_1	/* test 1: constant expressions */
// #define SIR_PERFORM_TEST_2	/* test 2: HelloWorld with API layer 1 */


#ifdef SIR_PERFORM_TEST_1	/* requires templates for bitvectors */

#if (__GNUC__ == 2) && (__GNUC_MINOR__ < 8)
#define EXCLUDE_TEMPLATES
#else
#define INCLUDE_TEMPLATES
#endif

#ifdef INCLUDE_TEMPLATES
#include <bit.h>
#endif

#if (__GNUC__ == 2) && (__GNUC_MINOR__ == 91)
#define WORK_AROUND_EGCS112_BUGS
#endif

#endif /* SIR_PERFORM_TEST_1 */


/*** internal type declarations *****************************************/


	/* none */


/*** prototypes of internal functions ***********************************/


#ifdef SIR_PERFORM_TEST_1
static int SIR_Test1(void);
#endif /* SIR_PERFORM_TEST_1 */

#ifdef SIR_PERFORM_TEST_2
static int SIR_Test2(void);
#endif /* SIR_PERFORM_TEST_2 */


/*** exported variables *************************************************/


	/* none */


/*** internal variables *************************************************/


	/* none */


/*** class implementations **********************************************/


	/* none */


/************************************************************************/
/*** implementation of exported functions			      ***/
/************************************************************************/


	/* none */


/************************************************************************/
/*** implementation of internal functions			      ***/
/************************************************************************/


#ifdef SIR_PERFORM_TEST_1

static int SIR_Test1(void)
{
sir_constant	*Bool1,
		*Short42,
		*Int2,
		*Int3,
		*Int5,
		*Int958,
		*Long8,
		*LongLong1000,
		*Float0_5,
		*Float3_1415,
		*Double2_0,
		*LongDouble22e2,
		*BitVec0000111,
		*BitVec0000110;
sir_type	*TypeBool,
		*TypeChar,
		*TypeShort,
		*TypeInt,
		*TypeLong,
		*TypeLongLong,
		*TypeFloat,
		*TypeDouble,
		*TypeLongDouble,
		*TypeBitVec4,
		*TypeBitVec7,
		*TypeBitVec64,
		*TypeVoidPtr,
		*TypeArray10,
		*TypeE1,
		*TypeS1,
		*TypeS2,
		*TypeS3,
		*TypeS4,
		*TypeB1,
		*TypeB2,
		*TypeB3,
		*TypeU1,
		*TypeU2,
		*TypeU3;
sir_usertype	*UserTypeE1,
		*UserTypeS1,
		*UserTypeS2,
		*UserTypeS3,
		*UserTypeS4,
		*UserTypeB1,
		*UserTypeB2,
		*UserTypeB3,
		*UserTypeU1,
		*UserTypeU2,
		*UserTypeU3;
sir_members	*Members;
sir_expression	*MyExpression;
int		Result,
		Faults;
unsigned int	Result1,
		Result2,
#ifdef INCLUDE_TEMPLATES
#ifdef WORK_AROUND_EGCS112_BUGS
		SizeOfTmp1,
		SizeOfTmp2,
#endif /* WORK_AROUND_EGCS112_BUGS */
#endif /* INCLUDE_TEMPLATES */
		Alignment,
		Alignment2;


puts("Test 1: Checking constant expression evaluation...");

Faults = 0;

Bool1		= new SIR_Constant(SIR_CONST_BOOL, 1);
Short42		= new SIR_Constant(SIR_CONST_SHORT, 42);
Int2		= new SIR_Constant(SIR_CONST_INT, 2);
Int3		= new SIR_Constant(SIR_CONST_INT, 3);
Int5		= new SIR_Constant(SIR_CONST_INT, 5);
Int958		= new SIR_Constant(SIR_CONST_INT, 958);
Long8		= new SIR_Constant(SIR_CONST_LONG, (UNSIGNED_LONG_LONG)8);
LongLong1000	= new SIR_Constant(SIR_CONST_LONGLONG,(UNSIGNED_LONG_LONG)1000);
Float0_5	= new SIR_Constant(SIR_CONST_FLOAT, 0.5l);
Float3_1415	= new SIR_Constant(SIR_CONST_FLOAT, 3.1415l);
Double2_0	= new SIR_Constant(SIR_CONST_DOUBLE, 2.0l);
LongDouble22e2	= new SIR_Constant(SIR_CONST_LONGDOUBLE, 22e2l);
BitVec0000111	= new SIR_Constant(SIR_CONST_BIT, "0000111");
BitVec0000110	= new SIR_Constant(SIR_CONST_BIT, "0000110");

TypeBool	= new SIR_Type(SIR_TYPE_BOOL);
TypeChar	= new SIR_Type(SIR_TYPE_CHAR);
TypeShort	= new SIR_Type(SIR_TYPE_SHORT);
TypeInt		= new SIR_Type(SIR_TYPE_INT);
TypeLong	= new SIR_Type(SIR_TYPE_LONG);
TypeLongLong	= new SIR_Type(SIR_TYPE_LONGLONG);
TypeFloat	= new SIR_Type(SIR_TYPE_FLOAT);
TypeDouble	= new SIR_Type(SIR_TYPE_DOUBLE);
TypeLongDouble	= new SIR_Type(SIR_TYPE_LONGDOUBLE);
TypeBitVec4	= new SIR_Type(SIR_TYPE_BIT, false, false,  3, 0);
TypeBitVec7	= new SIR_Type(SIR_TYPE_BIT, false, false,  6, 0);
TypeBitVec64	= new SIR_Type(SIR_TYPE_BIT, false, false, 63, 0);
TypeVoidPtr	= new SIR_Type(new SIR_Type(SIR_TYPE_VOID), SIR_TYPE_POINTER);
TypeArray10	= new SIR_Type(TypeBool, SIR_TYPE_ARRAY, NULL, 10);

typedef enum E1{ x1, x2, x3 } e1;
Members		= new SIR_Members(/* no members necessary */);
UserTypeE1	= new SIR_UserType(SIR_USERTYPE_ENUM, "E1", NULL,
			Members);
TypeE1		= new SIR_Type(SIR_TYPE_ENUM, UserTypeE1->Name->chars(),
			UserTypeE1);

typedef struct S1{ char c; } s1;
Members		= new SIR_Members(new SIR_Member(TypeChar, NULL));
UserTypeS1	= new SIR_UserType(SIR_USERTYPE_STRUCT, "S1", NULL,
			Members, new SIR_Symbols(NULL, SIR_SCOPE_USERTYPE));
TypeS1		= new SIR_Type(SIR_TYPE_STRUCT, UserTypeS1->Name->chars(),
			UserTypeS1);
typedef struct S2{ short y; char c;} s2;
Members		= new SIR_Members(new SIR_Member(TypeShort, NULL));
Members->Append(new SIR_Member(TypeChar, NULL));
UserTypeS2	= new SIR_UserType(SIR_USERTYPE_STRUCT, "S2", NULL,
			Members, new SIR_Symbols(NULL, SIR_SCOPE_USERTYPE));
TypeS2		= new SIR_Type(SIR_TYPE_STRUCT, UserTypeS2->Name->chars(),
			UserTypeS2);
typedef struct S3{ double x; int c; } s3;
Members		= new SIR_Members(new SIR_Member(TypeDouble, NULL));
Members->Append(new SIR_Member(TypeInt, NULL));
UserTypeS3	= new SIR_UserType(SIR_USERTYPE_STRUCT, "S3", NULL,
			Members, new SIR_Symbols(NULL, SIR_SCOPE_USERTYPE));
TypeS3		= new SIR_Type(SIR_TYPE_STRUCT, UserTypeS3->Name->chars(),
			UserTypeS3);
#ifdef WORK_AROUND_EGCS112_BUGS
typedef struct S4{ char c;        S3 s3;} s4;
#else
typedef struct S4{ char c; struct S3 s3;} s4;
#endif /* WORK_AROUND_EGCS112_BUGS */
Members		= new SIR_Members(new SIR_Member(TypeChar, NULL));
Members->Append(new SIR_Member(TypeS3, NULL));
UserTypeS4	= new SIR_UserType(SIR_USERTYPE_STRUCT, "S4", NULL,
			Members, new SIR_Symbols(NULL, SIR_SCOPE_USERTYPE));
TypeS4		= new SIR_Type(SIR_TYPE_STRUCT, UserTypeS4->Name->chars(),
			UserTypeS4);

typedef struct B1{ int X : 5; } b1;
Members		= new SIR_Members(new SIR_Member(TypeInt, NULL, 5));
UserTypeB1	= new SIR_UserType(SIR_USERTYPE_STRUCT, "B1", NULL,
			Members, new SIR_Symbols(NULL, SIR_SCOPE_USERTYPE));
TypeB1		= new SIR_Type(SIR_TYPE_STRUCT, UserTypeB1->Name->chars(),
			UserTypeB1);
typedef struct B2{ int X : 29; int Y : 3; } b2;
Members		= new SIR_Members(new SIR_Member(TypeInt, NULL, 29));
Members->Append(new SIR_Member(TypeInt, NULL, 3));
UserTypeB2	= new SIR_UserType(SIR_USERTYPE_STRUCT, "B2", NULL,
			Members, new SIR_Symbols(NULL, SIR_SCOPE_USERTYPE));
TypeB2		= new SIR_Type(SIR_TYPE_STRUCT, UserTypeB2->Name->chars(),
			UserTypeB2);
typedef struct B3{ int X : 20; int Y : 20; int Z : 20; } b3;
Members		= new SIR_Members(new SIR_Member(TypeInt, NULL, 20));
Members->Append(new SIR_Member(TypeInt, NULL, 20));
Members->Append(new SIR_Member(TypeInt, NULL, 20));
UserTypeB3	= new SIR_UserType(SIR_USERTYPE_STRUCT, "B3", NULL,
			Members, new SIR_Symbols(NULL, SIR_SCOPE_USERTYPE));
TypeB3		= new SIR_Type(SIR_TYPE_STRUCT, UserTypeB3->Name->chars(),
			UserTypeB3);

typedef union U1{ short y; char c;} u1;
Members		= new SIR_Members(new SIR_Member(TypeShort, NULL));
Members->Append(new SIR_Member(TypeChar, NULL));
UserTypeU1	= new SIR_UserType(SIR_USERTYPE_UNION, "U1", NULL,
			Members, new SIR_Symbols(NULL, SIR_SCOPE_USERTYPE));
TypeU1		= new SIR_Type(SIR_TYPE_UNION, UserTypeU1->Name->chars(),
			UserTypeU1);
typedef union U2{ double x; int c; } u2;
Members		= new SIR_Members(new SIR_Member(TypeDouble, NULL));
Members->Append(new SIR_Member(TypeInt, NULL));
UserTypeU2	= new SIR_UserType(SIR_USERTYPE_UNION, "U2", NULL,
			Members, new SIR_Symbols(NULL, SIR_SCOPE_USERTYPE));
TypeU2		= new SIR_Type(SIR_TYPE_UNION, UserTypeU2->Name->chars(),
			UserTypeU2);
#ifdef WORK_AROUND_EGCS112_BUGS
typedef union U3{ char c;        S4 s4;} u3;
#else
typedef union U3{ char c; struct S4 s4;} u3;
#endif /* WORK_AROUND_EGCS112_BUGS */
Members		= new SIR_Members(new SIR_Member(TypeChar, NULL));
Members->Append(new SIR_Member(TypeS4, NULL));
UserTypeU3	= new SIR_UserType(SIR_USERTYPE_UNION, "U3", NULL,
			Members, new SIR_Symbols(NULL, SIR_SCOPE_USERTYPE));
TypeU3		= new SIR_Type(SIR_TYPE_UNION, UserTypeU3->Name->chars(),
			UserTypeU3);

MyExpression =
	new SIR_Expression(SIR_EXPR_MULTIPLY, TypeInt,
		new SIR_Expression(SIR_EXPR_MULTIPLY, TypeInt,
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(Int2), TypeInt),
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(Int3), TypeInt)),
		new SIR_Expression(SIR_EXPR_ADD, TypeInt,
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(Int5), TypeInt),
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(Int2), TypeInt)));
Result = MyExpression->IntegerEval();
assert(SIR_Error == SIR_ERROR_NO_ERROR);
printf("\t(2*3) * (5+2) = %d\t\t\t\t%s\n",
	Result, ((((2*3) * (5+2)) == Result)
		? "Correct." : (Faults++, "WRONG!!!")));
delete MyExpression;

MyExpression =
	new SIR_Expression(SIR_EXPR_GREATER, TypeInt,
		new SIR_Expression(SIR_EXPR_DIVIDE, TypeLongLong,
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(LongLong1000), TypeLongLong),
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(Long8), TypeLong)),
		new SIR_Expression(SIR_EXPR_OR, TypeInt,
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(Short42), TypeShort),
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(Bool1), TypeBool)));
Result = MyExpression->IntegerEval();
assert(SIR_Error == SIR_ERROR_NO_ERROR);
printf("\t(1000ll/8l) > (42|true) = %d\t\t\t%s\n",
	Result,
	((((((LONG_LONG)1000)/8l) > (42|true)) == Result)
		? "Correct." : (Faults++, "WRONG!!!")));
delete MyExpression;

MyExpression =
	new SIR_Expression(SIR_EXPR_ADD, TypeLongDouble,
		new SIR_Expression(SIR_EXPR_MULTIPLY, TypeFloat,
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(Float0_5), TypeFloat),
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(Float3_1415), TypeFloat)),
		new SIR_Expression(SIR_EXPR_DIVIDE, TypeLongDouble,
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(LongDouble22e2),
							TypeLongDouble),
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(Double2_0), TypeDouble)));
Result = MyExpression->IntegerEval();
assert(SIR_Error == SIR_ERROR_NO_ERROR);
printf("\t(int)((0.5f*3.1415f)+(22e2l/2.0)) = %d\t%s\n",
	Result,
	((((int)((0.5f*3.1415f)+(22e2l/2.0))) == Result) ?
					"Correct." : (Faults++, "WRONG!!!")));
delete MyExpression;

MyExpression =
	new SIR_Expression(SIR_EXPR_EOR, TypeBitVec64,
		new SIR_Expression(SIR_EXPR_MULTIPLY, TypeBitVec7,
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(BitVec0000111), TypeBitVec7),
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(BitVec0000110), TypeBitVec7)),
		new SIR_Expression(SIR_EXPR_SUBTRACT, TypeLongLong,
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(LongLong1000), TypeLongLong),
			new SIR_Expression(SIR_EXPR_CONSTANT,
				new SIR_Constant(Int958), TypeInt)));
Result = MyExpression->IntegerEval();
assert(SIR_Error == SIR_ERROR_NO_ERROR);
printf("\t(0000111b*0000110b)^(1000ll-958) = %d\t\t%s\n",
	Result,
	((((   7*    6)^(((LONG_LONG)1000)-958)) == Result) ?
					"Correct." : (Faults++, "WRONG!!!")));
delete MyExpression;

Result1 = TypeBool->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeBool;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(bool)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(bool))
	  &&(Result2 == sizeof(bool[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeChar->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeChar;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(char)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(char))
	  &&(Result2 == sizeof(char[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeShort->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeShort;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(short)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(short))
	  &&(Result2 == sizeof(short[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeInt->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeInt;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(int)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(int))
	  &&(Result2 == sizeof(int[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeLong->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeLong;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(long)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(long))
	  &&(Result2 == sizeof(long[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeLongLong->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeLongLong;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(lg.long)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(LONG_LONG))
	  &&(Result2 == sizeof(LONG_LONG[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeFloat->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeFloat;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(float)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(float))
	  &&(Result2 == sizeof(float[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeDouble->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeDouble;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(double)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(double))
	  &&(Result2 == sizeof(double[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeLongDouble->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeLongDouble;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(lg.dbl.)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(long double))
	  &&(Result2 == sizeof(long double[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

#ifdef INCLUDE_TEMPLATES
Result1 = TypeBitVec4->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeBitVec4;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
#ifdef WORK_AROUND_EGCS112_BUGS
SizeOfTmp1 = sizeof(bit<4>);
SizeOfTmp2 = sizeof(bit<4>[10]);
printf("\tsizeof(bit[4])\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == SizeOfTmp1)
	  &&(Result2 == SizeOfTmp2)
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));
#else /* WORK_AROUND_EGCS112_BUGS */
printf("\tsizeof(bit[4])\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(bit<4>))
	  &&(Result2 == sizeof(bit<4>[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));
#endif /* WORK_AROUND_EGCS112_BUGS */

Result1 = TypeBitVec64->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeBitVec64;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(bit[64])\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(bit<64>))
	  &&(Result2 == sizeof(bit<64>[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));
#endif /* INCLUDE_TEMPLATES */

Result1 = TypeVoidPtr->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeVoidPtr;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(void*)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(void*))
	  &&(Result2 == sizeof(void*[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeE1->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeE1;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(e1)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(e1))
	  &&(Result2 == sizeof(e1[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeS1->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeS1;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(s1)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(s1))
	  &&(Result2 == sizeof(s1[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeS2->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeS2;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(s2)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(s2))
	  &&(Result2 == sizeof(s2[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeS3->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeS3;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(s3)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(s3))
	  &&(Result2 == sizeof(s3[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeS4->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeS4;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(s4)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(s4))
	  &&(Result2 == sizeof(s4[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeB1->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeB1;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(b1)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(b1))
	  &&(Result2 == sizeof(b1[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeB2->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeB2;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(b2)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(b2))
	  &&(Result2 == sizeof(b2[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeB3->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeB3;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(b3)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(b3))
	  &&(Result2 == sizeof(b3[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeU1->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeU1;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(u1)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(u1))
	  &&(Result2 == sizeof(u1[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeU2->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeU2;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(u2)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(u2))
	  &&(Result2 == sizeof(u2[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

Result1 = TypeU3->SizeOf(&Alignment, FALSE);
TypeArray10->SubType = TypeU3;
Result2 = TypeArray10->SizeOf(&Alignment2, FALSE);
printf("\tsizeof(u3)\t= %d\t(%d-byte aligned) [%d]\t%s\n",
	Result1, Alignment, Result2,
	((  (Result1 == sizeof(u3))
	  &&(Result2 == sizeof(u3[10]))
	  && (Alignment == Alignment2))
			? "Correct." : (Faults++, "WRONG!!!")));

delete Bool1;
delete Short42;
delete Int2;
delete Int3;
delete Int5;
delete Int958;
delete Long8;
delete LongLong1000;
delete Float0_5;
delete Float3_1415;
delete Double2_0;
delete LongDouble22e2;
delete BitVec0000111;
delete BitVec0000110;

delete TypeBool;
delete TypeChar;
delete TypeShort;
delete TypeInt;
delete TypeLong;
delete TypeLongLong;
delete TypeFloat;
delete TypeDouble;
delete TypeLongDouble;
delete TypeBitVec4;
delete TypeBitVec7;
delete TypeBitVec64;
delete TypeVoidPtr->SubType; delete TypeVoidPtr;
delete TypeArray10;
delete TypeE1; delete UserTypeE1;
delete TypeS1; delete UserTypeS1;
delete TypeS2; delete UserTypeS2;
delete TypeS3; delete UserTypeS3;
delete TypeS4; delete UserTypeS4;
delete TypeB1; delete UserTypeB1;
delete TypeB2; delete UserTypeB2;
delete TypeB3; delete UserTypeB3;
delete TypeU1; delete UserTypeU1;
delete TypeU2; delete UserTypeU2;
delete TypeU3; delete UserTypeU3;

printf("\tNumber of faults = %d\n", Faults);
if (Faults)
   { puts("Test 1: Failed!\n");
     return(RESULT_ERROR);
    } /* fi */

puts("Test 1: Done.\n");

return(RESULT_OK);

} /* end of SIR_Test1 */

#endif /* SIR_PERFORM_TEST_1 */


/************************************************************************/


#ifdef SIR_PERFORM_TEST_2

static int SIR_Test2(void)
{
sir_design	*Design1;
sir_fileinfo	*MyFile;
sir_note	*MyNote;
sir_type	*MyType,
		*Arg1Type,
		*Arg2Type,
		*PortType;
sir_type_ptrs	*ArgTypes;
sir_parameter	*MyPort,
		*Parameter;
sir_symbol	*MySymbol,
		*MyFunction;
sir_symbols	*MyScope,
		*MyClassScope,
		*LocalScope;
sir_statement	*MyStatement;
sir_labels	*LabelList;
sir_statements	*StatementList;
sir_constant	*MyConst;
sir_expression	*MyExpression;
sir_expressions	*MyArgs;
sir_label	*MyLabel;
FILE		*FileHandle;
ERROR		Error;


puts("Test 2: Playing with the famous 'HelloWorld' design...");
puts("        (using SIR API layer 1)");


// this is, what we want to create:
//
//  1:		note FileName = "HelloWorld.sc";
//  2:
//  3:		extern void printf(const char *, ...);
//  4:
//  5:		behavior Main(void)
//  6:		{
//  7:			int main(void)
//  8:			{
//  9:			char	*Name;
// 10:
// 11:			label1:	Name = "World";
// 12:				printf("Hello %s!\n", Name);
// 13:				return(0);
// 14:			}
// 15:		};


printf("\tCreating the design from scratch...");

	/* start with an empty design */

Design1 = new SIR_Design("HelloWorld");

	/* create a file entry */

MyFile = Design1->FileList->FindOrInsert("HelloWorld.sc");

	/* create the note in line 1 */

MyNote = new SIR_Note("FileName",	/* create the note */
			new SIR_Constant(SIR_CONST_CHARSTRING,
					"HelloWorld.sc",
					1, MyFile));
if ((Error = Design1->Annotate(MyNote)))
   { GL_PrintError(Error, SIR_ErrorText(Error));
     puts("Building design failed, test aborted!");
     delete MyNote;
     delete Design1;
     return(RESULT_ERROR);
    } /* fi */

	/* create the function declaration in line 3 */

Arg1Type = Design1->Types->FindOrInsert(/* first argument type	*/
		SIR_TYPE_POINTER,	/* is a pointer to	*/
		Design1->Types->FindOrInsert(
			SIR_TYPE_CHAR,	/* 'const char'		*/
			true));
Arg2Type = Design1->Types->FindOrInsert(/* second argument type	*/
		SIR_TYPE_ANY_TYPE);	/* is '...'		*/
ArgTypes = new sir_type_ptrs(
		new sir_type_ptr(Arg1Type));
ArgTypes->Append(new sir_type_ptr(Arg2Type));
MyType = Design1->Types->FindOrInsert(	/* finally build the function type */
		SIR_TYPE_FUNCTION,
		Design1->Types->FindOrInsert(	/* return type */
			SIR_TYPE_VOID),
		ArgTypes);
MySymbol = new SIR_Symbol(		/* build the symbol 'printf' */
		SIR_SYMBOL_IDENTIFIER,
		"printf",
		MyType,
		SIR_STORAGE_EXTERN, 0,
		NULL,	/* no initializer */
		3, MyFile);
Design1->Symbols->Insert(MySymbol);	/* insert it in the symbol table */

	/* create the behavior starting in line 5 */

PortType = Design1->Types->FindOrInsert(/* port list is void */
		SIR_TYPE_VOID);
MyPort = new SIR_Parameter(		/* create the port */
		PortType);
MyClassScope = new SIR_Symbols(		/* open a local scope for the content */
		Design1->Symbols,	/* (global scope is parent) */
		SIR_SCOPE_CLASS);
MySymbol = new SIR_Symbol(		/* build the symbol 'Main' */
		SIR_SYMBOL_BEHAVIOR,
		"Main",
		NULL,	/* type not created yet (symbol is needed for that) */
		new SIR_Parameters(MyPort),
		MyClassScope,
		new SIR_SymbolPtrs(),	/* empty interface list */
		5, MyFile);
Arg1Type = PortType;			/* now we can create the type */
ArgTypes = new sir_type_ptrs(
		new sir_type_ptr(Arg1Type));
MyType = Design1->Types->FindOrInsertClassType(	/* create the behavior type */
		SIR_TYPE_BEHAVIOR,
		MySymbol->Name.chars(),
		ArgTypes,
		MySymbol);
MySymbol->Type = MyType;		/* note the type in the symbol and */
Design1->Symbols->Insert(MySymbol);	/* insert it in the symbol table   */

LocalScope = MySymbol->ClassScope;	/* "enter" the behavior scope */

	/* create the local 'main' function starting in line 7 */

Arg1Type = Design1->Types->FindOrInsert(/* argument type is 'void' */
			SIR_TYPE_VOID);
ArgTypes = new sir_type_ptrs(		/* build parameter list */
		new sir_type_ptr(Arg1Type));
MyType = Design1->Types->FindOrInsert(	/* finally build the function type */
		SIR_TYPE_FUNCTION,
		Design1->Types->FindOrInsert(	/* return type 'int' */
			SIR_TYPE_INT),
		ArgTypes);
MyScope = new SIR_Symbols(		/* create a scope for parameters */
		LocalScope,		/* (parent is behavior scope) */
		SIR_SCOPE_PARAMETER);
Parameter = new SIR_Parameter(		/* build parameter for the symbol */
		Arg1Type,		/* (which has its own copy) */
		NULL);	/* no symbol (because it's void) */
LabelList = new SIR_Labels();		/* empty label list */
MyFunction = new SIR_Symbol(		/* build the symbol 'main' */
		"main",
		MyType,
		SIR_STORAGE_NONE,
		new SIR_Parameters(Parameter),
		MyScope,
		LabelList,
		NULL,	/* no function body yet */
		7, MyFile);
StatementList = new SIR_Statements();	/* empty statement list */
MyStatement = new SIR_Statement(	/* function body is a compound stmnt. */
		SIR_STMNT_COMPOUND, MyFunction,
		new SIR_Symbols(	/* compound statement scope */
			MyScope,	/* (parent is function scope) */
			SIR_SCOPE_STATEMENT,
			MyFunction),
		StatementList,
		8, MyFile);
MyFunction->FctBody = MyStatement;	/* insert compound statement as body */

LocalScope->Insert(MyFunction);		/* insert func. in beh. symbol table */

LocalScope = MyStatement->Scope;	/* "enter" the statement scope */

	/* create the local variable definition in line 9 */

MyType = Design1->Types->FindOrInsert(	/* create type 'char *' */
		SIR_TYPE_POINTER,
		Design1->Types->FindOrInsert(
			SIR_TYPE_CHAR));
MySymbol = new SIR_Symbol(		/* build the symbol 'Name' */
		SIR_SYMBOL_IDENTIFIER,
		"Name",
		MyType,
		SIR_STORAGE_NONE, 0,
		NULL,	/* no initializer */
		9, MyFile);
LocalScope->Insert(MySymbol);		/* insert the symbol in curr. scope */

	/* create the labeled assignment statement in line 11 */

MyConst = new SIR_Constant(		/* create the string constant */
		SIR_CONST_CHARSTRING,
		"World",
		11, MyFile);
MyExpression = new SIR_Expression(	/* create the assignment expression */
		SIR_EXPR_ASSIGNMENT,
		(LocalScope->Find("Name"))	/* return type is type */
				->Type,		/* of left argument    */
		new SIR_Expression(	/* left argument */
			SIR_EXPR_IDENTIFIER,
			LocalScope->Find("Name"),
			11, MyFile),
		new SIR_Expression(	/* right argument */
			SIR_EXPR_CONSTANT,
			MyConst,
			MyType,
			11, MyFile),
		NULL,	/* no third argument */
		11, MyFile);
MyStatement = new SIR_Statement(	/* create the assignment statement */
		SIR_STMNT_EXPRESSION, MyFunction,
		MyExpression,
		NULL, NULL,	/* no sub-statements */
		11, MyFile);
MyLabel = new SIR_Label(		/* create a label */
		"label1",
		NULL);	/* _labeled_ statement not known yet */
LabelList->Insert(MyLabel);		/* insert the label in the list */
MyStatement = new SIR_Statement(	/* create the labeled statement */
		SIR_STMNT_LABELED, MyFunction,
		MyLabel,
		MyStatement,	/* sub-statement */
		11, MyFile);
MyLabel->Statement = MyStatement;	/* fill in the statement */
StatementList->Append(MyStatement);	/* append to the list of statements */

	/* create the function call in line 12 */

MyArgs = new SIR_Expressions(		/* create the argument list */
		new SIR_Expression(
			SIR_EXPR_CONSTANT,	/* first is string constant */
			new SIR_Constant(
				SIR_CONST_CHARSTRING,
				"Hello %s!\n"),
			MyType,
			12, MyFile));
MyArgs->Append(new SIR_Expression(
			SIR_EXPR_IDENTIFIER,	/* second is identifier */
			LocalScope->Find("Name"),
			12, MyFile));
MyExpression = new SIR_Expression(	/* create the functioncall expression */
		SIR_EXPR_FUNCTION_CALL,
		(LocalScope->Find("printf"))	/* return type is return type */
			->Type->SubType,	/* of the declared function   */
		new SIR_Expression(	/* the function is an expression */
			SIR_EXPR_IDENTIFIER,
			LocalScope->Find("printf"),
			12, MyFile),
		MyArgs,
		12, MyFile);
MyStatement = new SIR_Statement(	/* create the assignment statement */
		SIR_STMNT_EXPRESSION, MyFunction,
		MyExpression,
		NULL, NULL,	/* no sub-statements */
		12, MyFile);
StatementList->Append(MyStatement);	/* append to the list of statements */

	/* create the return statement in line 13 */

MyExpression = new SIR_Expression(	/* create the return value */
		SIR_EXPR_CONSTANT,
		new SIR_Constant(
			SIR_CONST_INT,
			0),
		Design1->Types->FindOrInsert(SIR_TYPE_INT),
		13, MyFile);
MyStatement = new SIR_Statement(	/* create the return statement */
		SIR_STMNT_RETURN, MyFunction,
		new SIR_Expression(	/* actually the ()'s are optional */
			SIR_EXPR_PARENTHESES,
			MyExpression->Type,
			MyExpression,
			(sir_expression*)NULL, (sir_expression*)NULL,
			13, MyFile),
		NULL, NULL,	/* no sub-statements */
		13, MyFile);
StatementList->Append(MyStatement);	/* append to the list of statements */

puts(" Done.");


printf("\tGenerate SpecC code of the design... (\"HelloWorld2.sc\")");

if (!(FileHandle = GL_OpenFileForWriting("HelloWorld2.sc")))
   { GL_PrintError(GL_Error, GL_ErrorText(GL_Error));
     puts("Opening file 'HelloWorld2.sc' failed, test aborted!");
     GL_CloseFile(FileHandle);
     delete Design1;
     return(RESULT_ERROR);
    } /* fi */

if ((Error = Design1->WriteSC(FileHandle, "HelloWorld2.sc")))
   { GL_PrintError(Error, SIR_ErrorText(Error));
     puts("Source code generation failed, test aborted!");
     GL_CloseFile(FileHandle);
     delete Design1;
     return(RESULT_ERROR);
    } /* fi */

if ((Error = GL_CloseFileWithCheck(FileHandle)))
   { GL_PrintError(Error, GL_ErrorText(Error));
     puts("Writing design failed, test aborted!");
     delete Design1;
     return(RESULT_ERROR);
    } /* fi */

puts(" Done.");


printf("\tCleaning up...");

delete Design1;		/* delete the design */

puts(" Done.");


puts("Test 2: Done.\n");

return(RESULT_OK);

} /* end of SIR_Test2 */

#endif /* SIR_PERFORM_TEST_2 */


/************************************************************************/
/*** main (for debugging only)					      ***/
/************************************************************************/


#ifdef DEBUG	/* module self test */


int main(int argc, char **argv)
{
int		Result;

printf("DEBUGGING: IntRep ('%s')\n\n", argv[0]);
if (argc != 1)
   { puts("WARNING: Arguments will be ignored!\n");
    } /* fi */

#ifdef SIR_PERFORM_TEST_1
Result = SIR_Test1();
if (Result != RESULT_OK)
   { puts("Aborting!");
     return(Result);
    } /* fi */
#endif /* SIR_PERFORM_TEST_1 */

#ifdef SIR_PERFORM_TEST_2
Result = SIR_Test2();
if (Result != RESULT_OK)
   { puts("Aborting!");
     return(Result);
    } /* fi */
#endif /* SIR_PERFORM_TEST_2 */

puts("Exiting.");
return(RESULT_OK);	/* success! */

} /* end of main */

#endif /* DEBUG */


/* EOF IntRep.cc */
