// try24.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior Try
{
	void main(void)
	{
	waitfor 10;
	}
};

behavior Interrupt(inout int x)
{
	void main(void)
	{
	x++;
	waitfor 2;
	}
};

behavior Exception(inout int x, in event e)
{
	Try		t;
	Interrupt	i(x);

	void main(void)
	{
	try {	t.main();
		}
		interrupt e
		    {	i.main();
			};
	}
};

behavior Trigger(out event e)
{
	void main(void)
	{
	waitfor 3;
	notify e;
	waitfor 3;
	notify e;
	waitfor 3;
	}
};

behavior Main
{
	event		e1;
	int		x = 0;

	Exception	e(x, e1);
	Trigger		t(e1);

	int main(void)
	{
	puts("try24: Starting...");

	e.main();
	assert(x == 0);
	assert(now() == 10);

	par {	e.main();
		t.main();
		}
	assert(x == 2);
	assert(now() == 24);

	par {	e.main();
		t.main();
		}
	assert(x == 4);
	assert(now() == 38);

	puts("try24: Done.");
	return(0);
	}
};

// EOF
