/************************************************************************/
/* IntRep/Declarator.h: SpecC Internal Representation, Declarator Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 02/10/98 */
/************************************************************************/

/* last update: 04/12/99 */

/* NOTE: This file contains special support for the SpecC parser. */
/*       It is not used in a standard SpecC data structure.	  */

#ifndef INTREP_DECLARATOR_H
#define INTREP_DECLARATOR_H


#include "Global.h"
#include "IntRep/BasicType.h"


/*** enumeration types **************************************************/


	/* none */


/*** type definitions ***************************************************/


typedef class SIR_Declarator		sir_declarator;
typedef class SIR_DeclSpec		sir_declspec;


/*** class declarations *************************************************/


	/**********************/
	/*** SIR_Declarator ***/
	/**********************/


class SIR_Declarator		/* declarator */
{
public:
sir_type_list	*DeclTypes;	/* declarator type list (or NULL) */
sir_parameters	*Parameters;	/* parameter list (or NULL) */
sir_symbols	*ParamScope;	/* parameter's scope (or NULL) */
string		*SymbolName;	/* symbol name (or NULL) */
unsigned int	Line;		/* line of the declaration (or 0) */
sir_fileinfo	*FileInfo;	/* fileinfo of the declaration (or NULL) */
unsigned int	BitFieldSize;	/* bitfield size (for member decl. only) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Declarator(			/* constructor #1 (general) */
	sir_type_list	*DeclTypes = NULL,
	const char	*SymbolName = NULL,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL,
	unsigned int	BitFieldSize = 0);

SIR_Declarator(			/* constructor #2 (function support) */
	sir_type	*FirstDeclType,
	sir_parameters	*Parameters = NULL,
	sir_symbols	*ParamScope = NULL);

~SIR_Declarator(void);		/* destructor */
};


	/********************/
	/*** SIR_DeclSpec ***/
	/********************/


class SIR_DeclSpec		/* declaration specifier */
{
public:
sir_type	*BaseType;	/* link to base type entry in type table */
SIR_STORAGE	StorageClass;	/* storage class */
int		PipeStages;	/* number of pipeline stages (if PIPED) */
sir_members	*MemberList;	/* list of members (for usertypes only) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_DeclSpec(			/* constructor #1 (general) */
	sir_type	*BaseType,
	SIR_STORAGE	StorageClass = SIR_STORAGE_NONE,
	int		PipeStages = 0);

SIR_DeclSpec(			/* constructor #2 (from BasicType) */
	sir_types	*TypeTable,
	sir_basic_type	*BasicType);

~SIR_DeclSpec(void);		/* destructor */
};


/*** exported functions *************************************************/


	/* none */


#endif /* INTREP_DECLARATOR_H */

/* EOF IntRep/Declarator.h */
