/*****************************************************************************/
/* limits.sh: SpecC run-time implementation-specific constants               */
/*****************************************************************************/
/* Author: Andreas Gerstlauer			     First version: 05/24/01 */
/*****************************************************************************/

/* Modifications: (most recent first)
 *
 * 06/01/01 <gerstl>	Provided "reasonable" default for native LONG_LONG_MAX
 * 05/24/01 <gerstl>	Initial version
 */

_CPP_ifndef __LIMITS_SH
_CPP_define __LIMITS_SH

/* Include C compiler-specific constants */

_CPP_include <limits.h>


/* long long constants */
#ifdef HAVE_LLONG
_CPP_ifndef LONG_LONG_MAX
_CPP_ifdef LLONG_MAX
_CPP_define LONG_LONG_MAX     LLONG_MAX    // SOLARIS et al.
_CPP_elif defined(QUAD_MAX)
_CPP_define LONG_LONG_MAX     QUAD_MAX     // NETBSD
_CPP_else
_CPP_define LONG_LONG_MAX     0x7fffffffffffffffLL
_CPP_endif  
_CPP_endif

_CPP_ifndef ULONG_LONG_MAX
_CPP_ifdef ULLONG_MAX
_CPP_define ULONG_LONG_MAX    ULLONG_MAX   // SOLARIS et al.
_CPP_elif defined(UQUAD_MAX)
_CPP_define ULONG_LONG_MAX    UQUAD_MAX    // NETBSD
_CPP_else
_CPP_define ULONG_LONG_MAX    0xffffffffffffffffULL
_CPP_endif
_CPP_endif

_CPP_ifndef LLONG_MAX
_CPP_define LLONG_MAX         LONG_LONG_MAX
_CPP_endif

_CPP_ifndef ULLONG_MAX
_CPP_define ULLONG_MAX        ULONG_LONG_MAX
_CPP_endif
#else
_CPP_ifndef LONG_BIT
_CPP_define LONG_BIT          (sizeof(long) * CHAR_BIT)
_CPP_endif

_CPP_undef  LONG_LONG_MAX
_CPP_define LONG_LONG_MAX     (((long long)(LONG_MAX) << LONG_BIT) \\
                                                    & ((long long)ULONG_MAX) )
_CPP_undef  LLONG_MAX    
_CPP_define LLONG_MAX         LONG_LONG_MAX

_CPP_undef  ULONG_LONG_MAX
_CPP_define ULONG_LONG_MAX    (((unsigned long long)(ULONG_MAX) << LONG_BIT) \\
                                           & ((unsigned long long)ULONG_MAX) )
_CPP_undef  ULLONG_MAX    
_CPP_define ULLONG_MAX        ULONG_LONG_MAX
#endif
  
_CPP_endif /* __LIMITS_SH */

/* EOF limits.sh */
