/************************************************************************/
/* Parameter.cc: SpecC Internal Representation, Parameter Class		*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 02/10/98 */
/************************************************************************/

/* last update: 05/31/01 */

/* modifications: (most recent first)
 *
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/26/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	introduced this header (last change was 04/12/99)
 */

#include "IntRep/Parameter.h"
#include "IntRep/Symbol.h"

#include <assert.h>


/*** constants and macros ***********************************************/


	/* (none) */


/*** internal type declarations *****************************************/


	/* (none) */


/*** class implementations **********************************************/


	/*********************/
	/*** SIR_Parameter ***/
	/*********************/


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Parameter::SIR_Parameter(		/* constructor #1 (general) */
	sir_type	*Type,
	sir_symbol	*Symbol = NULL)
{

assert(Type != NULL);

SIR_Parameter::Type	= Type;
SIR_Parameter::Symbol	= Symbol;

} /* end of SIR_Parameter::SIR_Parameter #1 */


SIR_Parameter::SIR_Parameter(		/* constructor #3 (duplicator) */
	sir_parameter	*Original)
{

assert(Original != NULL);

SIR_Parameter::Type	= Original->Type;
SIR_Parameter::Symbol	= Original->Symbol;

} /* end of SIR_Parameter::SIR_Parameter #3 */


SIR_Parameter::~SIR_Parameter(void)	/* destructor */
{

/* nothing to do */

} /* end of SIR_Parameter::~SIR_Parameter */


	/**********************/
	/*** SIR_Parameters ***/
	/**********************/


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Parameters::SIR_Parameters(		/* constructor #1 */
	sir_parameter	*FirstEntry = NULL) :
		SIR_List<SIR_Parameter>(FirstEntry)
{

/* nothing else to do */

} /* end of SIR_Parameters::SIR_Parameters #1 */


SIR_Parameters::SIR_Parameters(		/* constructor #2 (duplicator) */
	sir_parameters	*Original)
{
sir_parameter	*Param;

assert(Original != NULL);

Param = Original->First();
while(Param)
   { Append(new SIR_Parameter(Param));
     Param = Param->Succ();
    } /* elihw */

} /* end of SIR_Parameters::SIR_Parameters #2 */


SIR_Parameters::SIR_Parameters(		/* constructor #3 (from type params) */
	sir_type_ptrs	*TypeParams)
{
sir_type_ptr	*Param;

assert(TypeParams != NULL);

Param = TypeParams->First();
while(Param)
   { Append(new SIR_Parameter(Param->Type));
     Param = Param->Succ();
    } /* elihw */

} /* end of SIR_Parameters::SIR_Parameters #3 */


SIR_Parameters::~SIR_Parameters(void)	/* destructor */
{

/* nothing to do */

} /* end of SIR_Parameters::~SIR_Parameters */


BOOL SIR_Parameters::IsVoid(void)	/* determines if there are no params. */
{

if (  (NumElements() == 0)
    ||(  (NumElements() == 1)
       &&(First()->Type->Type == SIR_TYPE_VOID)))
   { return(TRUE);
    } /* fi */

return(FALSE);

} /* end of SIR_Parameters::IsVoid */


void SIR_Parameters::UnAlias(void) /* unalias all type, usertype, symbol lks. */
{
sir_parameter	*Parameter;

Parameter = First();
while(Parameter)
   { if (Parameter->Type->Alias)
	{ Parameter->Type = Parameter->Type->Alias;
	 } /* fi */
     if (  (Parameter->Symbol)
	 &&(Parameter->Symbol->Alias))
	{ Parameter->Symbol = Parameter->Symbol->Alias;
	 } /* fi */
     Parameter = Parameter->Succ();
    } /* elihw */

} /* end of SIR_Parameters::UnAlias */


sir_parameter *SIR_Parameters::Find(	/* find corresponding parameter */
	sir_type_ptrs	*TypeParams,	/* (returns NULL if not found) */
	sir_type_ptr	*TypePtr)
{
sir_parameter	*Param;
sir_type_ptr	*TParam;

assert(TypeParams != NULL);
assert(TypePtr != NULL);

Param = First();	/* parallel list traversal */
TParam = TypeParams->First();
while(Param)
   { assert(TParam != NULL);
     if (TParam == TypePtr)
	{ break;
	 } /* fi */
     Param = Param->Succ();
     TParam = TParam->Succ();
    } /* elihw */

return(Param);

} /* end of SIR_Parameters::Find */


/*** exported functions *************************************************/


	/* none */


/* EOF Parameter.cc */
