/************************************************************************/
/* IntRep/Member.h: SpecC Internal Representation, Member Class		*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 10/08/97 */
/************************************************************************/

/* last update: 05/31/01 */

/* modifications: (most recent first)
 *
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	introduced this header (last change was 05/10/99)
 */

#ifndef INTREP_MEMBER_H
#define INTREP_MEMBER_H


#include "Global.h"
#include "IntRep/Type.h"


/*** constants and macros ***********************************************/


#define SIR_BITFIELD_SIZE_MIN	(1)
#define SIR_BITFIELD_SIZE_MAX	(sizeof(int)*8)
#define SIR_BITFIELD_SIZE_NONE	(0)


/*** enumeration types **************************************************/


	/* none */


/*** type definitions ***************************************************/


typedef class SIR_Member		sir_member;
typedef SIR_List<sir_member>		sir_member_list;
typedef class SIR_Members		sir_members;

typedef class SIR_Symbol		sir_symbol;	/* cyclic link */


/*** class declarations *************************************************/


	/******************/
	/*** SIR_Member ***/
	/******************/


class SIR_Member :		/* member of user-defined type */
	public SIR_Node,			/* is a node */
	public SIR_ListElem<SIR_Member>		/* and a list element */
{
public:
sir_type	*Type;		/* link to type table entry */
sir_symbol	*Symbol;	/* link to symbol table entry (NULL if none) */
unsigned int	BitFieldSize;	/* bitfield size (0 if none) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Member(			/* constructor #1 */
	sir_type	*Type,
	sir_symbol	*Symbol,
	unsigned int	BitFieldSize = 0,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL);

SIR_Member(			/* constructor #3 (duplicator) */
	sir_member	*Original);

~SIR_Member(void);		/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);
};


	/*******************/
	/*** SIR_Members ***/
	/*******************/


class SIR_Members :		/* list of members */
	public SIR_List<SIR_Member>	/* is simply a list of members */
{					/* with additional methods */
public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Members(			/* constructor #1 */
	sir_member	*FirstEntry = NULL);

SIR_Members(			/* constructor #2 (duplicator) */
	sir_members	*Original);

~SIR_Members(void);		/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);


void UnAlias(void);		/* unalias all type, usertype, symbol links */


sir_member *Find(		/* searches for a specific entry */
	sir_symbol	*Symbol);	/* (returns NULL if not found) */
};


#endif /* INTREP_MEMBER_H */

/* EOF IntRep/Member.h */
