/* Notes.sc */
/*----------*/

/*** general notes (attached to the design) ***/

note Author	= "Rainer Doemer";
note Date	= "Nov 07, 1997";
note Update	= "Mon Apr 20 17:23:08 PDT 1998";
note Day	= 7;
note Month	= 11;
note Year	= 1900 + 97;
note Comment1	= "This is an example of how to attach notes to a design.\n"
		  "A note can be any constant expression and can be attached "
		  "to any symbol or label in the description.";

interface I
{
	void Write(int Value);

	/*** notes inside interface ***/
	note Name = "I";
	note Write.Complexity = 0;
	note Write.ArgType = "integer";
};

channel C(void) implements I
{
	int	Storage;
	bool	Valid;

	void Write(int Value)
	{
	/*** notes inside function ***/
	note Write.Name = "Write";
	note Value.Type = "int";

	l1: Storage = Value;
	l2: Valid = true;
	/*** notes inside statements ***/
	note Storage.Color = "green";
	note l1.OpID = 42;
	note l2.OpID = 42+1;
	}

	/*** notes inside channel ***/
	note Name = "C";	/* same as: note C.Name = "C"; */
	note Storage.Bytes = sizeof(int);
};

behavior B(in int p1, I p2)
{
	int square(int a)
	{
	int r;
		{ int t;
		  /*** notes in compound statements ***/
		  note t.comment = "t is temporary only";
		  statement1: t = a * a;
		  note statement1.cost = 32 * 32;
		  statement2: r = t; }
	statement3: return(r);
	}

	void main(void)
	{
	const int x = 5;
	int y;
	/*** notes inside function ***/
	note Name = "main";	/* same as: note main.Name = "main"; */
	note x.Bits = sizeof(int) * 16 / 2 + (-42)/6 + 7.0;

	label1: y = square(x);
	}
	enum { E_TEMPORARY, E_STANDARD, E_INLINED };

	/*** notes inside behavior ***/
	note B.Name = "B";
	note main.FullName = "B.main";
	note square.type = E_INLINED;
	note E_TEMPORARY.blablabla = "stupid note at enum";
};

/*** notes attached to interface/channel/behavior names ***/

note I.comment	= "This is an one-way interface.";
note C.cost	= 512.50;
note B.version	= 1.0;


/*** notes for aggregate types ***/

struct S
{
	int a, b;
	note a.bits	= sizeof(int) * 8;
	float f;
	note f.bits	= sizeof(float) * 8;
};

note S.comment	= "for demonstration only";
note S.bits	= sizeof(struct S) * 8;

typedef struct /* unnamed */ { float x, y, z; } Vector3D;
note Vector3D.bits = sizeof(Vector3D) * 8;

/* EOF */
