/************************************************************************/
/* Transition.cc: SpecC Internal Representation, Transition Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 03/23/98 */
/************************************************************************/

/* last update: 05/31/01 */

/* modifications: (most recent first)
 *
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 04/30/01 RD	replaced use of obsolete form() from "stream.h" with own one
 * 01/30/01 RD	fixed a potential FMR problem in iterators
 *		SIR_Transitions::DFS_ForAllXxxxx
 */

#include "IntRep/Transition.h"
#include "IntRep/Design.h"

#include <assert.h>


/*** constants and macros ***********************************************/


	/* (none) */


/*** internal type declarations *****************************************/


	/* (none) */


/*** class implementations **********************************************/


	/**********************/
	/*** SIR_Transition ***/
	/**********************/


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Transition::SIR_Transition(		/* constructor #1 */
	sir_symbol	*Function,
	sir_symbol	*CurrState,
	sir_expression	*Condition,
	sir_symbol	*NextState,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL) :
		SIR_Node(Line, FileInfo)
{

assert(Function != NULL);
/* CurrState is temporary NULL in parser */

SIR_Transition::Function	= Function;
SIR_Transition::CurrState	= CurrState;
SIR_Transition::Condition	= Condition;
SIR_Transition::NextState	= NextState;

} /* end of SIR_Transition::SIR_Transition #1 */


SIR_Transition::SIR_Transition(		/* constructor #3 (duplicator) */
	sir_transition	*Original) :
		SIR_Node(Original)
{

SIR_Transition::Function	= Original->Function;
SIR_Transition::CurrState	= Original->CurrState;
SIR_Transition::Condition	= Original->Condition ?
					new SIR_Expression(
						Original->Condition) :
					NULL;
SIR_Transition::NextState	= Original->NextState;

} /* end of SIR_Transition::SIR_Transition #3 */


SIR_Transition::~SIR_Transition(void)	/* destructor */
{

delete Condition;

} /* end of SIR_Transition::~SIR_Transition */


sir_transitions *SIR_Transition::GetList(	/* determines the list */
	void)
{

return((sir_transitions*) Head());

} /* end of SIR_Transition::GetList */


ERROR SIR_Transition::DFS_ForAllNodes(	/* iterator for over all nodes */
	sir_node_mptr	MemberFct,	/* (depth first) */
	sir_node_marg	MemberFctArg)
{

if ((SIR_Error = (this->*MemberFct)(MemberFctArg)))	/* process this node */
   { return(SIR_Error);
    } /* fi */

if (Condition)
   { if ((SIR_Error = Condition->DFS_ForAllNodes(MemberFct, MemberFctArg)))
	{ return(SIR_Error);
	 } /* fi */
    } /* fi */

return(SIR_ERROR_NO_ERROR);

} /* end of SIR_Transition::DFS_ForAllNodes */


ERROR SIR_Transition::DFS_ForAllExpressions( /* iterator over all expressions */
	sir_expr_mptr	MemberFct,		/* (depth first) */
	sir_expr_marg	MemberFctArg)
{

/* this is not an expression */

if (Condition)
   { if ((SIR_Error = Condition->DFS_ForAllExpressions(MemberFct,
							MemberFctArg)))
	{ return(SIR_Error);
	 } /* fi */
    } /* fi */

return(SIR_ERROR_NO_ERROR);

} /* end of SIR_Transition::DFS_ForAllExpressions */


void SIR_Transition::UnAlias(void)/* unalias all type, usertype, symbol links */
{

if (  (Function)
    &&(Function->Alias))
   { Function = Function->Alias;
    } /* fi */
if (  (CurrState)
    &&(CurrState->Alias))
   { CurrState = CurrState->Alias;
    } /* fi */
if (Condition)
   { Condition->UnAlias();
    } /* fi */
if (  (NextState)
    &&(NextState->Alias))
   { NextState = NextState->Alias;
    } /* fi */

} /* end of SIR_Transition::UnAlias */


	/***********************/
	/*** SIR_Transitions ***/
	/***********************/


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Transitions::SIR_Transitions(	/* constructor #1 */
	sir_transition	*FirstEntry = NULL) :
		SIR_List<SIR_Transition>(FirstEntry)
{

/* nothing to do */

} /* end of SIR_Transitions::SIR_Transitions #1 */


SIR_Transitions::SIR_Transitions(	/* constructor #2 (duplicator) */
	sir_transitions	*Original)
{
sir_transition	*Curr;

Curr = Original->First();
while(Curr)
   { Append(new SIR_Transition(Curr));
     Curr = Curr->Succ();
    } /* elihw */

} /* end of SIR_Transitions::SIR_Transitions #2 */


SIR_Transitions::~SIR_Transitions(void)		/* destructor */
{

/* nothing to do */

} /* end of SIR_Transitions::~SIR_Transitions */


ERROR SIR_Transitions::DFS_ForAllNodes(	/* iterator over all nodes */
	sir_node_mptr	MemberFct,	/* (depth first) */
	sir_node_marg	MemberFctArg)
{
sir_transition	*Transition,
		*Succ;

/* this is not a node, but there are nodes below */

Transition = First();
while(Transition)
   { Succ = Transition->Succ();
     if ((SIR_Error = Transition->DFS_ForAllNodes(MemberFct, MemberFctArg)))
	{ return(SIR_Error);
	 } /* fi */
     Transition = Succ;
    } /* elihw */

return(SIR_ERROR_NO_ERROR);

} /* end of SIR_Transitions::DFS_ForAllNodes */


ERROR SIR_Transitions::DFS_ForAllExpressions(/* iterator over all expressions */
	sir_expr_mptr	MemberFct,		/* (depth first) */
	sir_expr_marg	MemberFctArg)
{
sir_transition	*Transition,
		*Succ;

/* this is not an expression, but there are expressions below */

Transition = First();
while(Transition)
   { Succ = Transition->Succ();
     if ((SIR_Error = Transition->DFS_ForAllExpressions(MemberFct,
							MemberFctArg)))
	{ return(SIR_Error);
	 } /* fi */
     Transition = Succ;
    } /* elihw */

return(SIR_ERROR_NO_ERROR);

} /* end of SIR_Transitions::DFS_ForAllExpressions */


void SIR_Transitions::UnAlias(void)/* unalias all type, usertype, symbol links*/
{
sir_transition	*Trans;

Trans = First();
while(Trans)
   { Trans->UnAlias();
     Trans = Trans->Succ();
    } /* elihw */

} /* end of SIR_Transitions::UnAlias */


sir_transition *SIR_Transitions::Find(	/* find specific transition #1 */
	sir_symbol	*CurrState,	/* (returns NULL if not found) */
	sir_symbol	*NextState)
{
sir_transition	*Trans;

Trans = FindCurrState(CurrState);
while(Trans)
   { if (Trans->NextState == NextState)
	{ break;
	 } /* fi */
     if (Trans->CurrState != CurrState)
	{ return(NULL);	/* end of sublist */
	 } /* fi */
     Trans = Trans->Succ();
    } /* elihw */

return(Trans);

} /* end of SIR_Transitions::Find #1 */


sir_transition *SIR_Transitions::FindCurrState(	/* find the sublist/state #1 */
	sir_symbol	*CurrState)	/* (returns NULL if not found) */
{
sir_transition	*Trans;

Trans = First();
while(Trans)
   { if (Trans->CurrState == CurrState)
	{ break;
	 } /* fi */
     Trans = Trans->Succ();
    } /* elihw */

return(Trans);

} /* end of SIR_Transitions::FindCurrState #1 */


sir_transition *SIR_Transitions::FindNextState(	/* find the next state #1 */
	sir_symbol	*NextState)	/* (returns NULL if not found) */
{
sir_transition	*Trans;

Trans = First();
while(Trans)
   { if (Trans->NextState == NextState)
	{ break;
	 } /* fi */
     Trans = Trans->Succ();
    } /* elihw */

return(Trans);

} /* end of SIR_Transitions::FindNextState #1 */


/*** exported functions *************************************************/


	/* none */


/* EOF Transition.cc */
