/************************************************************************/
/* IntRep/Transition.h: SpecC Internal Representation, Transition Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 03/23/98 */
/************************************************************************/

/* last update: 05/31/01 */

/* modifications: (most recent first)
 *
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	introduced this header (last change was 04/12/99)
 */

#ifndef INTREP_TRANSITION_H
#define INTREP_TRANSITION_H


#include "Global.h"
#include "IntRep/Expression.h"


/*** enumeration types **************************************************/


/* (none) */


/*** type definitions ***************************************************/


typedef class SIR_Transition		sir_transition;
typedef SIR_List<sir_transition>	sir_transition_list;
typedef class SIR_Transitions		sir_transitions;

typedef class SIR_Symbol		sir_symbol;	/* cyclic link */
typedef class SIR_Statement		sir_statement;	/* cyclic link */


/*** class declarations *************************************************/


	/**********************/
	/*** SIR_Transition ***/
	/**********************/


class SIR_Transition :		/* transition */
	public SIR_Node,			/* is a node */
	public SIR_ListElem<SIR_Transition>	/* and a list element */
{
public:
sir_symbol	*Function;	/* link back to the function this is part of */
sir_symbol	*CurrState;	/* link to from-behavior */
sir_expression	*Condition;	/* condition (or NULL for true) */
sir_symbol	*NextState;	/* link to to-behavior (or NULL for break) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Transition(			/* constructor #1 */
	sir_symbol	*Function,
	sir_symbol	*CurrState,
	sir_expression	*Condition,
	sir_symbol	*NextState,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL);

SIR_Transition(			/* constructor #3 (duplicator) */
	sir_transition	*Original);

~SIR_Transition(void);		/* destructor */


sir_transitions *GetList(void);	/* determines the list of this transition */
				/* (returns NULL if not in a list) */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

ERROR DFS_ForAllExpressions(	/* iterator over all expressions (dfs) */
	sir_expr_mptr	MemberFct,
	sir_expr_marg	MemberFctArg);


void UnAlias(void);		/* unalias all type, usertype, symbol links */
};


	/***********************/
	/*** SIR_Transitions ***/
	/***********************/


class SIR_Transitions :		/* transitions list */
	public SIR_List<SIR_Transition>	/* is simply a list of transitions */
{					/* with additional member(function)s */
public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Transitions(		/* constructor #1 */
	sir_transition	*FirstEntry = NULL);

SIR_Transitions(		/* constructor #2 (duplicator) */
	sir_transitions	*Original);

~SIR_Transitions(void);		/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

ERROR DFS_ForAllExpressions(	/* iterator over all expressions (dfs) */
	sir_expr_mptr	MemberFct,
	sir_expr_marg	MemberFctArg);


void UnAlias(void);		/* unalias all type, usertype, symbol links */


sir_transition *Find(		/* find a specific transition */
	sir_symbol	*CurrState,	/* (returns NULL if not found) */
	sir_symbol	*NextState);

sir_transition *FindCurrState(	/* find the sublist with this start state */
	sir_symbol	*CurrState);	/* (returns NULL if not found) */

sir_transition *FindNextState(	/* find the first trans. with this next state */
	sir_symbol	*NextState);	/* (returns NULL if not found) */
};


/*** exported functions *************************************************/


	/* none */


#endif /* INTREP_TRANSITION_H */

/* EOF IntRep/Transition.h */
