// Adder/ADD32_1.sc


import "ADD08_1";


behavior ADD32_1(		// 32-bit adder, structural model
	in bit[0:0]	c_in,
	in bit[31:0]	a,
	in bit[31:0]	b,
	out bit[31:0]	s,
	out bit[0:0]	c_out)
{
	bit[1]	c1, c2, c3;

	ADD08_1	add0(c_in, a[7:0], b[7:0], s[7:0], c1),
		add1(c1, a[15:8], b[15:8], s[15:8], c2),
		add2(c2, a[23:16], b[23:16], s[23:16], c3),
		add3(c3, a[31:24], b[31:24], s[31:24], c_out);

	void main(void)
	{
	add0.main();
	add1.main();
	add2.main();
	add3.main();
	}
};

// EOF
