.TH scrc l "May 25, 2001"
.SH NAME
scrc \- SpecC Reference Compiler
.SH SYNOPSIS
.B scrc
.I \-h

.B scrc
.I design
[
.I command
] [
.I options
]
.SH DESCRIPTION
.B scrc
is the compiler for the SpecC language.
The main purpose of
.B scrc
is to compile a SpecC source program into an executable program
for simulation. Furthermore,
.B scrc
serves as a general tool to translate SpecC code from various input
to various output formats which include SpecC source text, or
compiler intermediate files.

Using the first command syntax as shown in the synopsis above,
a brief usage information and the compiler version are printed to standard
output and the program exits.
Using the second command syntax, the specified
.I design
is compiled. By default,
.B scrc
reads a SpecC source file, performs preprocessing and builds the internal
data structure. Then, C++ code is generated, compiled and linked
into an executable file to be used for simulation.
However, the subtasks performed by
.B scrc
are controlled by the given
.I command
so that, for example, only partial compilation
is performed with the specified
.I design.

On successful completion, the exit value 0 is returned.
In case of errors during processing, an error code with a
brief diagnostic message is written to
standard error and the program execution is aborted
with the exit value 10.

For preprocessing and C++ compilation,
.B scrc
relies on the availability of an external C++ compiler which
is used automatically in the background. By default, the GNU compiler
.B gcc/g++
is used.
.SH ARGUMENTS
.TP
.I design
specifies the name of the design; by default, this name is used as
base name for the input file and all output files;
.SH COMMAND
The
.I command
has the format -
.I suffix1
2
.I suffix2,
where
.I suffix1
and
.I suffix2
specify the format of the main input and output file, respectively.
This command also implies the compilation steps being performed.
By default, the command \-sc2out is used which specifies reading
a SpecC source file (e.g. design.sc) and generating an executable file
(e.g. a.out) for simulation. All necessary intermediate files (e.g.
design.cc, design.o) are generated automatically.

Legal command suffixes are:
.TP
.I sc
SpecC source file (default:
.I design.sc)
.TP
.I si
preprocessed SpecC source file (default:
.I design.si)
.TP
.I cc
C++ simulation source file (default:
.I design.cc)
.TP
.I h
C++ simulation header file (default:
.I design.h)
.TP
.I cch
both, C++ simulation source file and C++ header file (default:
.I design.cc
and
.I design.h)
.TP
.I o
linker object file (default:
.I design.o)
.TP
.I out
executable file for simulation (default:
.I design)
.SH OPTIONS
.TP
.I \-v | \-vv | -vvv
increase the verbosity level so that all tasks performed are
logged to standard error (default: be silent);
at level 1, informative messages for each task performed are displayed;
at level 2, additionally input and output file names are listed;
at level 3, very detailed information about each executed task is printed;
.TP
.I \-w | \-ww | -www
increase the warning level so that warning messages are enabled
(default: warnings are disabled); four levels are supported ranging
from only important warnings (level 1) to pedantic warnings (level 4);
for most cases, warning level 2 is recommended (\-ww);
.TP
.I \-g
enable debugging of the generated simulation code (default: no debugging code);
this option disables optimization;
.TP
.I \-O
enable optimization of the generated simulation code
(default: no optimization); this option disables debugging;
.TP
.I \-sl
suppress source line information (preprocessor directives) when generating
SpecC or C++ source code
(default: include source line directives);
.TP
.I \-sn
suppress all annotations when generating SpecC source code
(default: include annotations);
.TP
.I \-i input file
specify the name of the input file explicitly (default:
.I design.suffix1);
the name '-' can be used to specify reading from standard input;
.TP
.I \-o output file
specify the name of the final output file explicitly (default:
.I design.suffix2);
the name '-' can be used to specify writing to standard output;
.TP
.I \-D
do not define any standard macros; by default, the macro
__SPECC__ is defined automatically (it is set to 1); furthermore,
implementation dependent macros may be defined; this option suppresses
the definition of all these macros;
.TP
.I \-Dmacrodef
define the preprocessor macro
.I macrodef
to be passed to the preprocessor;
.TP
.I \-U
do not undefine any macros; by default, few macros
are undefined automatically (in order to allow C/C++ standard header files
to be used); this option is implementation dependent;
.TP
.I \-Uundef
undefine the preprocessor macro
.I undef
which will be passed to the preprocessor as being undefined;
the macro
.I undef
will be undefined after the definition of all command-line macros;
this allows to selectively suppress macros from being
defined in the preprocessing stage;
.TP
.I \-I
clear the standard include path; by default, the standard include
path consists of the directory $SPECC/inc; this option suppresses
the default include path;
.TP
.I \-Idir
append
.I dir
to the include path (extend the list of directories to be searched
for including source files);
include directories are searched in the order of their specification;
unless suppressed by option \-I, the standard include path is
automatically appended to this list;
by default, only the standard include directories are searched;
.TP
.I \-L
clear the standard library path; by default, the standard library
path consists of the directory $SPECC/lib; this option suppresses
the default library path;
.TP
.I \-Ldir
append
.I dir
to the library path (extend the list of directories to be searched
for linker libraries);
the library path is searched in the specified order;
unless suppressed by option \-L, the standard library path is
automatically appended to this list;
by default, only the standard library path is searched;
.TP
.I \-l
when linking, do not use any standard libraries; the default
libraries are displayed when calling the compiler with the \-h
option; the \-l option suppresses
linking against theses standard libraries;
.TP
.I \-llib
pass
.I lib
as a library to the linker so that the executable is linked against
.I lib;
libraries are linked in the specified order;
unless suppressed by option \-l, the standard libraries are
automatically appended to this list;
by default, only standard libraries are used;
.TP
.I \-P
reset the import path; clear the list of directories to be searched
for importing files; by default, only the current directory
is searched; this option suppresses this standard import path;
.TP
.I \-Pdir
append
.I dir
to the import path (extend the list of directories to be searched
for importing files);
import directories are searched in the order of their specification;
unless suppressed by option \-P, the standard search path is
automatically appended to this list; by default, only the standard
import path is searched;
.TP
.I \-xpp preprocessor_call
redefine the command to be used for calling the C preprocessor
(default: "g++ -E -x c %p %i -o %o");
in the specified string, every occurence of %p will be replaced
with a preprocessor option; additional options will be appended;
also, %i and %o will be replaced automatically with the actual input
and output filename, respectively;
.TP
.I \-xcc compiler_call
redefine the command to be used for calling the C/C++ compiler
(default: "g++ -c %c %i -o %o");
in the specified string, every occurence of %c will be replaced
with a compiler option; additional options will be appended;
also, %i and %o will be replaced automatically
with the actual input and output filename, respectively;
.TP
.I \-xld linker_call
redefine the command to be used for calling the linker
(default: "g++ %i -o %o %l");
in the specified string, every occurence of %l will be replaced
with a linker option; additional options will be appended;
also, %i and %o will be replaced automatically
with the actual input and output filename, respectively;
.TP
.I \-xp preprocessor_option
pass an option directly to the C/C++ preprocessor; for every %p in
the preprocessor call (see above), an option has to be specified
(default: none);
.TP
.I \-xc compiler_option
pass an option directly to the C/C++ compiler; for every %c in
the compiler call (see above), an option has to be specified
(default: none);
.TP
.I \-xl linker_option
pass an option directly to the linker; for every %l in
the linker call (see above), an option has to be specified
(default: none);
.SH ENVIRONMENT
The environment variable SPECC is used to determine the
home directory of the SpecC system where SpecC standard include
files and SpecC system libraries are located.
.SH VERSION
The SpecC reference compiler
.B scrc
is version 1.0.
.SH AUTHOR
Rainer Doemer <doemer@ics.uci.edu>
.SH COPYRIGHT
(c) 1997-2001 CECS, University of California, Irvine
.SH "SEE ALSO"
.BR gcc (1),
.BR g++ (1),
.SH BUGS, LIMITATIONS
Semantic type checking of certain expressions is not fully implemented.
