/************************************************************************/
/* piped.h: SpecC run-time simulation library, 'piped' template impl.	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 03/28/01 */
/************************************************************************/

/* last update: 04/25/01 */

/* modifications: (most recent first)
 *
 * 04/25/01 RD	added copy-assignment method (bug fix)
 * 04/04/01 RD	completed function bodies
 * 04/03/01 RD	inserted initial implementation
 * 03/28/01 RD	initial version
 */

#ifndef __PIPED_H
#define __PIPED_H

/* NOTE:							*/
/*	this "header" file contains the _implementation_ of	*/
/*	the 'piped' template class				*/


#include <string.h>


/*** class implementations **********************************************/


	/**********************/
	/*** piped template ***/
	/**********************/


template<class T> inline
piped<T>::piped(void)		/* constructor #1 */
{

piped::fDepth		= 1;
piped::fValue		= new T[2];

memset(&piped::fValue[0], 0, sizeof(T));
memset(&piped::fValue[1], 0, sizeof(T));

} /* end of piped<T>::piped #1 */


template<class T> inline
piped<T>::piped(		/* constructor #2 */
	unsigned int	fDepth)
{
unsigned int	i;

piped::fDepth		= fDepth;
piped::fValue		= new T[fDepth+1];

for(i=0; i<=fDepth; i++)
   { memset(&piped::fValue[i], 0, sizeof(T));
    } /* rof */

} /* end of piped<T>::piped #2 */


template<class T> inline
piped<T>::piped(		/* constructor #3 (copy constructor) */
	const piped<T>	&PipedVar)
{
unsigned int	i;

piped::fDepth		= PipedVar.fDepth;
piped::fValue		= new T[PipedVar.fDepth+1];

for(i=0; i<=PipedVar.fDepth; i++)
   { memcpy(&piped::fValue[i], &PipedVar.fValue[i], sizeof(T));
    } /* rof */

} /* end of piped<T>::piped #3 */


template<class T> inline
piped<T>::~piped(void)		/* destructor */
{

delete[] fValue;

} /* end of piped<T>::~piped */


template<class T> inline	/* conversion operator (read access) */
piped<T>::operator T() const
{

return(fValue[0]);

} /* end of piped<T>::operator T */


template<class T> inline
piped<T> &piped<T>::operator=(		/* assignment operator #1 */
	T	Var)
{

memcpy(&fValue[fDepth], &Var, sizeof(T));

return *this;

} /* end of piped<T>::operator= */


template<class T> inline
piped<T> &piped<T>::operator=(		/* assignment operator #1b */
	const piped<T>	&PipedVar)	/* (needed, otherwise compiler  */
{					/* will generate 'bad' default) */

memcpy(&fValue[fDepth], &PipedVar.fValue[0], sizeof(T));

return *this;

} /* end of piped<T>::operator= */


template<class T> inline
piped<T> &piped<T>::operator+=(		/* assignment operator #2 */
	T	Var)
{

fValue[fDepth] = fValue[0] + Var;

return *this;

} /* end of piped<T>::operator+= */


template<class T> inline
piped<T> &piped<T>::operator-=(		/* assignment operator #3 */
	T	Var)
{

fValue[fDepth] = fValue[0] - Var;

return *this;

} /* end of piped<T>::operator-= */


template<class T> inline
piped<T> &piped<T>::operator*=(		/* assignment operator #4 */
	T	Var)
{

fValue[fDepth] = fValue[0] * Var;

return *this;

} /* end of piped<T>::operator*= */


template<class T> inline
piped<T> &piped<T>::operator/=(		/* assignment operator #5 */
	T	Var)
{

fValue[fDepth] = fValue[0] / Var;

return *this;

} /* end of piped<T>::operator/= */


template<class T> inline
piped<T> &piped<T>::operator%=(		/* assignment operator #6 */
	T	Var)
{

fValue[fDepth] = fValue[0] % Var;

return *this;

} /* end of piped<T>::operator%= */


template<class T> inline
piped<T> &piped<T>::operator^=(		/* assignment operator #7 */
	T	Var)
{

fValue[fDepth] = fValue[0] ^ Var;

return *this;

} /* end of piped<T>::operator^= */


template<class T> inline
piped<T> &piped<T>::operator&=(		/* assignment operator #8 */
	T	Var)
{

fValue[fDepth] = fValue[0] & Var;

return *this;

} /* end of piped<T>::operator&= */


template<class T> inline
piped<T> &piped<T>::operator|=(		/* assignment operator #9 */
	T	Var)
{

fValue[fDepth] = fValue[0] | Var;

return *this;

} /* end of piped<T>::operator|= */


template<class T> inline
piped<T> &piped<T>::operator<<=(	/* assignment operator #10 */
	T	Var)
{

fValue[fDepth] = fValue[0] << Var;

return *this;

} /* end of piped<T>::operator<<= */


template<class T> inline
piped<T> &piped<T>::operator>>=(	/* assignment operator #11 */
	T	Var)
{

fValue[fDepth] = fValue[0] >> Var;

return *this;

} /* end of piped<T>::operator>>= */


template<class T> inline
piped<T> &piped<T>::operator++()	/* increment operator #1 (pre-) */
{

fValue[fDepth] = fValue[0] + 1;

return *this;

} /* end of piped<T>::operator++ */


template<class T> inline
piped<T> piped<T>::operator++(int)	/* increment operator #2 (post-) */
{
piped<T>	Tmp = *this;

fValue[fDepth] = fValue[0] + 1;

return Tmp;

} /* end of piped<T>::operator++ */


template<class T> inline
piped<T> &piped<T>::operator--()	/* decrement operator #1 (pre-) */
{

fValue[fDepth] = fValue[0] - 1;

return *this;

} /* end of piped<T>::operator-- */


template<class T> inline
piped<T> piped<T>::operator--(int)	/* decrement operator #2 (post-) */
{
piped<T>	Tmp = *this;

fValue[fDepth] = fValue[0] - 1;

return Tmp;

} /* end of piped<T>::operator-- */


template<class T>
void piped<T>::update(		/* shift the data in the pipeline */
	void)
{
unsigned int	i;

for(i=0; i<fDepth; i++)
   { memcpy(&fValue[i], &fValue[i+1], sizeof(T));
    } /* rof */

} /* end of piped<T>::update */


#endif /* __PIPED_H */

/* EOF piped.h */
