/**************************************************************/
/* ArrayCopy.sc: test program to check for array-copy feature */
/**************************************************************/

/* last update: 05/21/01 by RD */

/* test results:
 * -------------
 *
 * a) gcc ArrayCopy.c -o ArrayCopy
 *    => Error "incompatible types in assignment"
 *
 * b) gcc -ansi -pedantic ArrayCopy.c -o ArrayCopy
 *    => Error "incompatible types in assignment"
 *
 * c) g++ ArrayCopy.cc -o ArrayCopy
 *    => OK!
 *
 * d) g++ -ansi -pedantic ArrayCopy.cc -o ArrayCopy
 *    => Warning "ANSI C++ forbids assignment of arrays"
 *
 * e) cc ArrayCopy.c -o ArrayCopy
 *    => Error "left operand must be modifiable lvalue: op "=""
 *
 * f) cc -Xc ArrayCopy.c -o ArrayCopy
 *    => Error "left operand must be modifiable lvalue: op "=""
 *
 * g) CC ArrayCopy.cc -o ArrayCopy
 *    => Error "The operand "*A" cannot be assigned to"
 *
 * h) CC -compat=5 ArrayCopy.cc -o ArrayCopy
 *    => Error "The operand "*A" cannot be assigned to"
 */

#include <stdio.h>
#include <assert.h>

#ifdef __SPECC__
behavior Main
{
#endif /* __SPECC__ */

int main(void)
{
int	A[10],
	B[10];
int	i;

puts("Initializing...");
for(i=0;i<10;i++)
   { A[i] = i;
     B[i] = 10-i;
    }

puts("Printing...");
for(i=0;i<10;i++)
   { printf("A[%d] = %d, ", i, A[i]);
     printf("B[%d] = %d\n", i, B[i]);
    }

puts("Array-copying... (A=B)");
A = B;

puts("Printing...");
for(i=0;i<10;i++)
   { printf("A[%d] = %d, ", i, A[i]);
     printf("B[%d] = %d\n", i, B[i]);
    }

puts("Checking...");
for(i=0;i<10;i++)
   { assert(A[i] == B[i]);
    }

puts("Done.");
return(0);
}

#ifdef __SPECC__
};
#endif /* __SPECC__ */


/* EOF */
