/************************************************************************/
/* IntRep/Unit.h: SpecC Internal Representation, Unit Base Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 09/24/97 */
/************************************************************************/

/* last update: 05/25/01 */

/* modifications: (most recent first)
 *
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	introduced this header (last change was 04/12/99)
 */

#ifndef INTREP_UNIT_H
#define INTREP_UNIT_H


#include "Global.h"
#include "IntRep/Error.h"


/*** constants and macros ***********************************************/


	/* (none) */


/*** enumeration types **************************************************/


enum SIR_Color	/* (-:  colorful code  :-) */
{
SIR_WHITE,	/* default color (always clean up with white!) */
SIR_RED,
SIR_YELLOW,
SIR_GREEN,
SIR_BLUE,
SIR_BLACK
};


/*** type definitions ***************************************************/


typedef enum SIR_Color			SIR_COLOR;

typedef class SIR_Unit			sir_unit;


/*** class declarations *************************************************/


	/****************/
	/*** SIR_Unit ***/
	/****************/


class SIR_Unit			/* base class for all units in the design */
{
public:
SIR_COLOR	Color;		/* color of this unit (for marker algorithms) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Unit(void);			/* constructor #1 */

~SIR_Unit(void);		/* destructor */
};


#endif /* INTREP_UNIT_H */

/* EOF IntRep/Unit.h */
