/************************************************************************/
/* IntRep/FileInfo.h: SpecC Internal Representation, File Info Classes	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 09/24/97 */
/************************************************************************/

/* last update: 05/31/01 */

/* modifications: (most recent first)
 *
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	introduced this header (last change was 12/29/98)
 */

#ifndef INTREP_FILEINFO_H
#define INTREP_FILEINFO_H


#include "Global.h"
#include "IntRep/List.h"


/*** enumeration types **************************************************/


	/* none */


/*** type definitions ***************************************************/


typedef class SIR_LineInfo		sir_lineinfo;

typedef class SIR_FileInfo		sir_fileinfo;
typedef SIR_List<sir_fileinfo>		sir_fileinfo_list;
typedef class SIR_FileList		sir_file_list;

typedef class SIR_Design		sir_design;	/* cyclic link */


/*** class declarations *************************************************/


	/********************/
	/*** SIR_LineInfo ***/
	/********************/


class SIR_LineInfo :		/* (source) line information */
	public SIR_Unit			/* is a unit of the design */
{
public:
static BOOL		Enabled;	/* internal stuff */
static unsigned int	LastLine;
static sir_fileinfo	*LastFile;
static int		Tabulator;
static const char	*CurrentFile;
static unsigned int	CurrentLine;

unsigned int	Line;		/* line number */
sir_fileinfo	*File;		/* link to file information */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_LineInfo(				/* constructor #1 */
	unsigned int	Line,
	sir_fileinfo	*File);

~SIR_LineInfo(void);			/* destructor */


static void InitWriteSC(	/* prepares for writing new SpecC line infos */
	bool		Enable,
	const char	*ThisFilename = NULL,	/* default location if */
	unsigned int	ThisLineNumber = 1);	/* line info unknown   */

ERROR WriteSC(			/* writes line and file in SpecC source */
	FILE		*OutFile,
	bool		PutSpace = FALSE);

static void WriteNL(		/* writes a newline in SpecC source */
	FILE		*OutFile);	/* (regardless of any line info) */

static void WriteSPACE(		/* writes a space in SpecC source */
	FILE		*OutFile);	/* (regardless of any line info) */

static void WriteNewSC(		/* writes unknown line info */
	FILE		*OutFile,	/* (probably newly created stuff) */
	bool		PutSpace = FALSE);

static void Add2Tabulator(	/* increments tabulator for indenting */
	int		Tabs);	/* (decrements for Tabs < 0) */
};


	/********************/
	/*** SIR_FileInfo ***/
	/********************/


class SIR_FileInfo :		/* (source) file information */
	public SIR_ListElem<SIR_FileInfo>	/* is a list element */
{
public:
string		Filename;	/* file name */

sir_fileinfo	*Alias;		/* alias pointer (temporary only) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_FileInfo(			/* constructor #1 */
	const char	*Filename);

SIR_FileInfo(			/* constructor #3 (duplicator) */
	sir_fileinfo	*Original);

~SIR_FileInfo(void);		/* destructor */
};


	/********************/
	/*** SIR_FileList ***/
	/********************/


class SIR_FileList :		/* list of (source) files */
	public SIR_List<SIR_FileInfo>	/* is a basically a list */
{					/* with additional functions */
public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_FileList(			/* constructor #1 */
	sir_fileinfo	*NewFirstEntry = NULL);

SIR_FileList(			/* constructor #2 (duplicator) */
	sir_file_list	*Original);

~SIR_FileList(void);		/* destructor */


ERROR Integrate(			/* integrates imported filelist */
	sir_file_list	*Imported);

void GarbageCollection(			/* garbage collector */
	sir_design	*Design);


sir_fileinfo *FindOrInsert(		/* find an entry or insert it */
	const char	*Filename);	/* if it not exists           */

sir_fileinfo *Find(			/* find an entry */
	const char	*Filename);	/* (returns NULL if not found) */
};


#endif /* INTREP_FILEINFO_H */

/* EOF IntRep/FileInfo.h */
