// copy2.sc



// Regression test for second bug in copyBits (MSBs not copied correctly).





// ACTION:

// bitvector Somebits is assigned to bitvector Widerbits

// which is one bit wider than Somebits

//

//

// PROBLEM:

// when using explicit bitslicing the msb of Somebits is ignored

//

// problem only occurs when Somebits is wider than 32 bits

//

// when using implicit bitslicing everthing behaves as expected

//

//

// 03/16/99 Martin von Weymarn





#include <stdio.h>

#include <assert.h>





#define BITNUM 33       // correct result only for BITNUM <= 32





behavior Main

{

  unsigned bit[BITNUM-1:0] Somebits;      // bitvector of BITNUM width

  unsigned bit[BITNUM:0] Widerbit;        // one bit wider than Somebits





  int main(void)

    {

      int i;



      Somebits = 0;

      //Somebits = ~Somebits;               // set Somebits to all ones



      Widerbit = 0;

      Widerbit = ~Widerbit;               // set Widerbits to all ones



      for(i=0; i <= BITNUM-1; i++)

	printf("%d ", (int)Somebits[i]);

      printf("\n");





      Widerbit[BITNUM-1:0] = Somebits;      // Widerbit[BITNUM-1] not updated if BITNUM > 32

      //Widerbit = Somebits;              // this works regardless of BITNUM value





      for(i=0; i <= BITNUM-1; i++) {

	printf("%d ", (int)Widerbit[i]);

	assert((int)Widerbit[i] == (int)Somebits[i]);

      }

      printf("\n");

      

      return(0);

    }



};

