/************************************************************************/
/* Initializer.cc: SpecC Internal Representation, Initializer Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 02/10/98 */
/************************************************************************/

/* last update: 05/31/01 */

/* modifications: (most recent first)
 *
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 04/30/01 RD	replaced use of obsolete form() from "stream.h" with own one
 * 01/30/01 RD	fixed a potential FMR problem in iterator
 *		SIR_Initials::DFS_ForAllNodes
 */

#include "IntRep/Initializer.h"

#include <assert.h>


/*** constants and macros ***********************************************/


	/* none */


/*** internal type declarations *****************************************/


	/* (none) */


/*** class implementations **********************************************/


	/***********************/
	/*** SIR_Initializer ***/
	/***********************/


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Initializer::SIR_Initializer(	/* constructor #1 */
	sir_initials	*InitList,
	sir_constant	*Initializer)
{

assert(  ((InitList == NULL) && (Initializer != NULL))
       ||((InitList != NULL) && (Initializer == NULL)));

SIR_Initializer::InitList	= InitList;
SIR_Initializer::Initializer	= Initializer;

} /* end of SIR_Initializer::SIR_Initializer #1 */


SIR_Initializer::SIR_Initializer(	/* constructor #3 (duplicator) */
	sir_initializer	*Original)
{

SIR_Initializer::InitList	= (Original->InitList ?
					new SIR_Initials(Original->InitList) :
					NULL);
SIR_Initializer::Initializer	= (Original->Initializer ?
				new SIR_Constant(Original->Initializer) :
					NULL);

} /* end of SIR_Initializer::SIR_Initializer #3 */


SIR_Initializer::~SIR_Initializer(void)	/* destructor */
{

delete InitList;
delete Initializer;

} /* end of SIR_Initializer::~SIR_Initializer */


ERROR SIR_Initializer::DFS_ForAllNodes(	/* iterator for over all nodes */
	sir_node_mptr	MemberFct,	/* (depth first) */
	sir_node_marg	MemberFctArg)
{

/* this is not a node, but there are nodes below */

if (InitList)
   { if ((SIR_Error = InitList->DFS_ForAllNodes(MemberFct, MemberFctArg)))
	{ return(SIR_Error);
	 } /* fi */
    } /* fi */
if (Initializer)
   { if ((SIR_Error = Initializer->DFS_ForAllNodes(MemberFct, MemberFctArg)))
	{ return(SIR_Error);
	 } /* fi */
    } /* fi */

return(SIR_ERROR_NO_ERROR);

} /* end of SIR_Initializer::DFS_ForAllNodes */


ERROR SIR_Initializer::WriteSC(	/* (re-) generates SpecC source code */
	FILE		*File,
	BOOL		CplusplusMode)
{
sir_initializer	*Init;

if (InitList)
   { fputc('{', File);
     Init = InitList->First();
     while(Init)
	{ if ((SIR_Error = Init->WriteSC(File, CplusplusMode)))
	     { return(SIR_Error);
	      } /* fi */
	  Init = Init->Succ();
	  if (Init)
	     { fputc(',', File);
	      } /* fi */
	 } /* elihw */
     fputc('}', File);
    } /* fi */
else
   { assert(Initializer != NULL);
     fputs(Initializer->Print(CplusplusMode), File);	/* print constant */
    } /* esle */

if (ferror(File))
   { SIR_ErrMsg.form("Writing to file failed%s",
			GL_SystemErrorMessage());
     return(SIR_ERROR_WRITING_SPECC_FILE);
    } /* fi */

return(SIR_ERROR_NO_ERROR);

} /* end of SIR_Initializer::WriteSC */


	/********************/
	/*** SIR_Initials ***/
	/********************/


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Initials::SIR_Initials(		/* constructor #1 */
	sir_initializer	*NewFirstEntry = NULL) :
		SIR_List<SIR_Initializer>(NewFirstEntry)
{

/* nothing else to do */

} /* end of SIR_Initials::SIR_Initials #1 */


SIR_Initials::SIR_Initials(		/* constructor #2 (duplicator) */
	sir_initials	*Original)
{
sir_initializer	*Init;

assert(Original != NULL);

Init = Original->First();
while(Init)
   { Append(new SIR_Initializer(Init));
     Init = Init->Succ();
    } /* elihw */

} /* end of SIR_Initials::SIR_Initials #2 */


SIR_Initials::~SIR_Initials(void)	/* destructor */
{

/* nothing to do */

} /* end of SIR_Initials::~SIR_Initials */


ERROR SIR_Initials::DFS_ForAllNodes(	/* iterator over all nodes */
	sir_node_mptr	MemberFct,	/* (depth first) */
	sir_node_marg	MemberFctArg)
{
sir_initializer	*Initial,
		*Succ;

/* this is not a node, but there are nodes below */

Initial = First();
while(Initial)
   { Succ = Initial->Succ();
     if ((SIR_Error = Initial->DFS_ForAllNodes(MemberFct, MemberFctArg)))
	{ return(SIR_Error);
	 } /* fi */
     Initial = Succ;
    } /* elihw */

return(SIR_ERROR_NO_ERROR);

} /* end of SIR_Initials::DFS_ForAllNodes */


/*** exported functions *************************************************/


	/* none */


/* EOF Initializer.cc */
