// Adder2.sc: (debugging) version using constant and open port mappings
//
// last change: 06/07/01 RD


#include <stdlib.h>
#include <stdio.h>


behavior Int(out int a, in int b, in int c)
{
	void main(void)
	{
	a = b + c;
	}
};

behavior CInt(out int a, in const int b, in const int c)
{
	void main(void)
	{
	a = b + c;
	}
};

behavior OR2(			// two-port OR gate
	in bit[0:0]	a,
	in bit[0:0]	b,
	out bit[0:0]	c)
{
	void main(void)
	{
	c = a | b;
	}
};

behavior AND2(			// two-port AND gate
	in bit[0:0]	a,
	in bit[0:0]	b,
	out bit[0:0]	c)
{
	void main(void)
	{
	c = a & b;
	}
};

behavior XOR2(			// two-port Exclusive-OR gate
	in bit[0:0]	a,
	in bit[0:0]	b,
	out bit[0:0]	c)
{
	void main(void)
	{
	c = a ^ b;
	}
};

behavior HA(			// half-adder
	in bit[0:0]	a,
	in bit[0:0]	b,
	out bit[0:0]	s,
	out bit[0:0]	c)
{
XOR2	xor1(a, b, s);
AND2	and1(a, b, c);

bit[1]	dummy1, dummy2;

OR2	or1_const_test(1b,0b,dummy1);	// test: constants at both input ports
OR2	or2_const_test(a,1ub,dummy2);	// test: one constant input port

OR2	or1_const2_test((-1b),(-1b),dummy1);	// test: constant expressions
OR2	or2_const2_test((1b+1b),(~1ub),dummy2);	// test: one constant input port

//OR2	or1_open_test(,,);	// ERROR: totally unconnected OR gate
//OR2	or2_open_test(b, ,c);	// ERROR: input port open!
OR2	or3_open_test(a,b, );	// OK: output port open

// negative tests:
//OR2	or1_error(a, b, 0b);	// ERROR: output port mapped to constant
OR2	or2_error(a, b, dummy1);// sometimes bad: two drivers for dummy1
//OR2	or3_error(a, b, a);	// ERROR: write to class input port
//OR2	or4_error(c, a, );	// ERROR: read from class output port

// integer port tests
int	Ia, Ib, Ic;
const int CIa, CIb, CIc;
Int	int1(Ia, Ib, Ic),
	int2(Ia, 2, 3),
	int3(  , (-2), (-3)),
	int4(Ib, (5*7-42), ((int)(101010b ^ 111111111ub)));
CInt	cint1(Ia, CIb, CIc),
	cint2(Ia, 2, 3),
	cint3(  , (-2), (-3)),
	cint4(Ib, (5*7-42), ((int)(101010b ^ 111111111ub)));

	void main(void)
	{
	xor1.main();
	and1.main();
	}
};

behavior FA(			// full-adder
	in bit[0:0]	a,
	in bit[0:0]	b,
	in bit[0:0]	c,
	out bit[1:0]	s)
{
bit[0:0]	x, y, z;
HA		ha1(a, b, y, x),
		ha2(y, c, s[0], z);
OR2		or1(x, z, s[1]);

	void main(void)
	{
	ha1.main();
	ha2.main();
	or1.main();
	}
};

behavior ADD8(			// simple 8-bit adder
	in bit[0:0]	c_in,
	in bit[7:0]	a,
	in bit[7:0]	b,
	out bit[7:0]	s,
	out bit[0:0]	c_out)
{
bit[1:7]	c = 0;

FA	fa0(a[0], b[0], c_in, c[1] @ s[0]),
	fa1(a[1], b[1], c[1], c[2] @ s[1]),
	fa2(a[2], b[2], c[2], c[3] @ s[2]),
	fa3(a[3], b[3], c[3], c[4] @ s[3]),
	fa4(a[4], b[4], c[4], c[5] @ s[4]),
	fa5(a[5], b[5], c[5], c[6] @ s[5]),
	fa6(a[6], b[6], c[6], c[7] @ s[6]),
	fa7(a[7], b[7], c[7], c_out @ s[7]);

	void main(void)
	{
	fa0.main();
	fa1.main();
	fa2.main();
	fa3.main();
	fa4.main();
	fa5.main();
	fa6.main();
	fa7.main();
	}
};

behavior Main(void)		// testbench
{
// bit[1]	GND = 0;	// NEW in LRM1.0: can map to constants
// bit[1]	DC  = 0;	// NEW in LRM1.0: can have open ports
bit[7:0]	In1 = 0,
		In2 = 0,
		Out = 0;

// ADD8		Adder(GND, In1, In2, Out, DC);	// old style

ADD8		Adder(	0b,		// NEW in LRM1.0: can map to constants
			In1, In2, Out,
			/* nothing */);	// NEW in LRM1.0: can have open ports

bit[8]	dummy1, dummy2, dummy3;

ADD8		Adder2(In1[6],
			In2[2:3]@In2[0:1]@In1[3:6],
			00b     @ 10ub   @ 0101b,
			dummy1,
			dummy2[7]);

ADD8		Adder3(In1[6],
			In2[2:3]@ 10ub   @In1[3:6],
			00b     @In2[0:1]@ 0101b,
			dummy3,
			dummy2[5]);

ADD8		Adder4(In1[6],
			In2[2:3]@ 10ub   @In1[3:6],
			00b     @In2[0:1]@ 0101b,
			,
			);

	int main(int argc, char **argv)
	{
	int		a, b;
	bit[7:0]	a8, b8, s8;

	if (argc == 3)
	   { a = atoi(argv[1]);
	     b = atoi(argv[2]);
	    } /* fi */
	else
	   { a = 27;
	     b = 15;
	    } /* esle */
	printf("8-bit adder: %d + %d =", a, b);

	In1 = a;
	In2 = b;
	Adder.main();
	printf(" %d", (int)Out);

	a8 = a;
	b8 = b;
	s8 = a8 + b8;
	if (Out != s8)
	   { printf(" FALSE!!! (should be %d)\n", (int)s8);
	     return(10);
	    } /* fi */
	else
	   { printf(" (correct)\n");
	    } /* esle */
	return(0);
	}
};

// EOF
