// pipe6.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior A(out int x, inout int c)
{
	void main(void)
	{
	x = 1;
	c++;
	waitfor 5;
	}
};

behavior B(out int x, inout int c)
{
	void main(void)
	{
	x = 2;
	c++;
	waitfor 10;
	}
};

behavior C(out int x, inout int c)
{
	void main(void)
	{
	x = 3;
	c++;
	waitfor 8;
	}
};

behavior Main
{
	int	x = 0;
	int	c1 = 0,
		c2 = 0,
		c3 = 0;
	int	i;
	A	a(x, c1);
	B	b(x, c2);
	C	c(x, c3);

	int main(void)
	{
	puts("pipe6: Starting...");

	pipe(i=0; i<3; i++)
	   {	a.main();
		b.main();
		c.main();
		};
	assert(x == 3);
	assert((c1 == 3) && (c2 == 3) && (c3 == 3));
	assert(now() == 43);

	x = 4;
	pipe(i=0; i<3; i++)
	   {	c.main();
		b.main();
		a.main();
		};
	assert(x == 1);
	assert((c1 == 6) && (c2 == 6) && (c3 == 6));
	assert(now() == 86);

	puts("pipe6: Done.");
	return(0);
	}
};

// EOF
