// ClassAccess.sc:
// ---------------

interface I1
{
	int square(int);
};

interface I2
{
	int times2(int);
};

channel C implements I1, I2
{
	const int two(void)
	{
	return 2;
	}

	int times2(int x)
	{
	return two()*x;
	}

	int square(int x)
	{
	return x*x;
	}
};

behavior B (in int a, inout int b) implements I1
{
	double dsquare(double x)
	{
	return x*x;
	}

	int square(int x)
	{
	return (int)dsquare(x);
	}

	C c;

	void main(void)
	{
	b = square(a);
	waitfor 10;
	b += (int)dsquare(a);
	waitfor 10;
	b += c.square(a);
	waitfor 10;
	b += c.times2(a);
	waitfor 10;
//	b += c.two();		// private!
	}
};

behavior Main
{
	int a, b;
	B b1(a, b);
	C c1;

	int main(void)
	{
	int x;
	a = 42;
	b1.main();
	x = b;
	x += b1.square(10);
//	x += b1.dsquare(10);	// private!
	x += c1.square(11);
	x += c1.times2(11);
//	x += c1.two();		// private!
	return(0);
	}
};
