/* Behaviors.sc: Examples of CLEAN SpecC Behaviors: */


behavior B_extern(in int a, out int b);

behavior B_leaf(in int a, out int b)
{
	void main(void)
	{
	b = 2*a + 1;
	}
};

behavior B_sub(void)	/* dummy sub-behavior */
{
void main(void)
{
/* empty */
}
};

behavior B_par(in int a, out int b)
{
	B_sub	b1, b2, b3;

	void main(void)
	{
	par{	b1.main();
		b2.main();
		b3.main();
		}
	}
};

behavior B_pipe(in int a, out int b)
{
	B_sub	b1, b2, b3;

	void main(void)
	{
	pipe{	b1.main();
		b2.main();
		b3.main();
		}
	}
};

behavior B_seq(in int a, out int b)
{
	B_sub	b1, b2, b3;

	void main(void)
	{
		b1.main();
		b2.main();
		b3.main();
	}
};

behavior B_fsm(in int a, out int b)
{
	B_sub	b1, b2, b3;

	void main(void)
	{
	fsm{	b1:	{ 		goto b2;	}
		b2:	{ if (a > 0)	goto b1;
					goto b3;	}
		b3:	{ 		break;		}
		}
	}
};

behavior B_exception(in event e1, in event e2)
{
	B_sub	b1, b2, b3;

	void main(void)
	{
	try {	b1.main(); }
		interrupt (e1)	{ b2.main(); }
		trap (e2)	{ b3.main(); }
	}
};


/* EOF */
