// try27.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior Try(in event e2)
{
	void main(void)
	{
	wait e2;
	}
};

behavior Interrupt(inout int x)
{
	void main(void)
	{
	x++;
	waitfor 5;
	}
};

behavior Exception(inout int x, in event e1, in event e2)
{
	Try		t(e2);
	Interrupt	i(x);

	void main(void)
	{
	try {	t.main();
		}
		interrupt e1
		    {	i.main();
			};
	}
};

behavior Trigger(in int x, out event e1, out event e2)
{
	void main(void)
	{
	waitfor 3;
	notify e1;
	waitfor 3;
	notify e2;
	waitfor 3;

	assert(x == 1);
	assert(now() == 9);
	puts("try27: Expecting deadlock... (Done.)");
	}
};

behavior Main
{
	event		e1, e2;
	int		x = 0;

	Exception	e(x, e1, e2);
	Trigger		t(x, e1, e2);

	int main(void)
	{
	puts("try27: Starting...");

	par {	e.main();
		t.main();
		}

	assert(false);
	return(0);
	}
};

// EOF
