// par3.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior A1(inout int x)
{
	void main(void)
	{
	waitfor 1;
	assert(x == 0);
	x++;
	}
};

behavior A2(inout int x)
{
	void main(void)
	{
	waitfor 2;
	assert(x == 1);
	x++;
	}
};

behavior A3(inout int x)
{
	void main(void)
	{
	waitfor 3;
	assert(x == 2);
	x++;
	}
};

behavior A(inout int x)
{
	A1	a1(x);
	A2	a2(x);
	A3	a3(x);

	void main(void)
	{
	assert(x == 0);
	par {	a1.main();
		a2.main();
		a3.main();
		}
	assert(x == 3);
	}
};

behavior B1(inout int x)
{
	void main(void)
	{
	waitfor 1;
	assert(x == 1);
	x = 2;
	}
};

behavior B2(inout int x)
{
	void main(void)
	{
	waitfor 2;
	assert(x == 2);
	x = 3;
	}
};

behavior B3(inout int x)
{
	void main(void)
	{
	waitfor 3;
	assert(x == 3);
	x = 4;
	}
};

behavior B(inout int y)
{
	B1	b1(y);
	B2	b2(y);
	B3	b3(y);

	void main(void)
	{
	assert(y == 1);
	par {	b1.main();
		b2.main();
		b3.main();
		}
	assert(y == 4);
	}
};

behavior C1(inout int x)
{
	void main(void)
	{
	waitfor 10;
	assert(x == 2);
	x = 3;
	}
};

behavior C2(inout int x)
{
	void main(void)
	{
	waitfor 20;
	assert(x == 3);
	x = 4;
	}
};

behavior C3(inout int x)
{
	void main(void)
	{
	waitfor 30;
	assert(x == 4);
	x = 5;
	}
};

behavior C(inout int z)
{
	C1	c1(z);
	C2	c2(z);
	C3	c3(z);

	void main(void)
	{
	assert(z == 2);
	par {	c1.main();
		c2.main();
		c3.main();
		}
	assert(z == 5);
	}
};

behavior AB(inout int x, inout int y)
{
	A	a(x);
	B	b(y);

	void main(void)
	{
	par {	a.main();
		b.main();
		}
	}
};

behavior BC(inout int y, inout int z)
{
	B	b(y);
	C	c(z);

	void main(void)
	{
	par {	b.main();
		c.main();
		}
	}
};

behavior CA(inout int z, inout int x)
{
	C	c(z);
	A	a(x);

	void main(void)
	{
	par {	c.main();
		a.main();
		}
	}
};

behavior Main(void)
{
	int	a1 = 0, a2 = 0,
		b1 = 1, b2 = 1,
		c1 = 2, c2 = 2;
	AB	ab(a1, b1);
	BC	bc(b2, c1);
	CA	ca(c2, a2);

	int main(void)
	{
	puts("par3: Starting...");

	par {	ab.main();
		bc.main();
		ca.main();
		}
	assert(a1 == 3);
	assert(a2 == 3);
	assert(b1 == 4);
	assert(b2 == 4);
	assert(c1 == 5);
	assert(c2 == 5);
	assert(now() == 30);

	puts("par3: Done.");
	return(0);
	}
};

// EOF
