/************************************************************************/
/* Error.c: SpecC Internal Representation, Error Handling		*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 10/10/97 */
/************************************************************************/

/* last update: 05/31/01 */

/* modifications: (most recent first)
 *
 * 05/31/01 RD	removed code not needed for the SCRC
 * 02/14/01 RD	started this list (last changes was 04/08/99)
 */


#include "IntRep/Error.h"

#include <stdlib.h>


/*** constants and macros ***********************************************/


	/* none */


/*** internal type declarations *****************************************/


	/* none */


/*** prototypes of internal functions ***********************************/


	/* none */


/*** exported variables *************************************************/


string		SIR_ErrMsg;
ERROR		SIR_Error = SIR_ERROR_NO_ERROR;	/* last error of this module */


/*** internal variables *************************************************/


	/* none */


/************************************************************************/
/*** implementation of exported functions			      ***/
/************************************************************************/


	/* error handling */

void SIR_Reset(void)		/* recover from error status */
{

GL_Reset();

SIR_Error = SIR_ERROR_NO_ERROR;
SIR_ErrMsg = "";

} /* end of SIR_Reset */


const char *SIR_ErrorText(	/* returns message of error code */
	ERROR	ErrorNumber)
{

if (  (ErrorNumber >= GL_ERROR_BASE)
    &&(ErrorNumber <= GL_ERROR_BASE + GL_ERROR_RANGE))
   { return(GL_ErrorText(ErrorNumber));
    } /* fi */

switch (ErrorNumber)
   { case SIR_ERROR_NO_ERROR:
	  return("No error (internal)");
     case SIR_ERROR_TYPE_CONFLICT:
	  return("Type conflict; illegal basic type");
     case SIR_ERROR_TYPE_SIGNED_BOOL:
	  return("Type 'bool' cannot be 'signed' or 'unsigned'");
     case SIR_ERROR_TYPE_SIGNED_FLOAT:
	  return("Type 'float' cannot be 'signed' or 'unsigned'");
     case SIR_ERROR_TYPE_SIGNED_DOUBLE:
	  return("Type 'double' cannot be 'signed' or 'unsigned'");
     case SIR_ERROR_TYPE_SIGNED_LONGDOUBLE:
	  return("Type 'long double' cannot be 'signed' or 'unsigned'");
     case SIR_ERROR_TYPE_SIGNED_VOID:
	  return("Type 'void' cannot be 'signed' or 'unsigned'");
     case SIR_ERROR_TYPE_PIPED_EVENT:
	  return("Type 'event' cannot be 'piped'");
     case SIR_ERROR_TYPE_SIGNED_EVENT:
	  return("Type 'event' cannot be 'signed' or 'unsigned'");
     case SIR_ERROR_TYPE_CONST_OR_VOLATILE_EVENT:
	  return("Type 'event' cannot be 'const' or 'volatile'");
     case SIR_ERROR_TYPE_SIGNED_TWICE:
	  return("Type modifier 'signed' specified twice");
     case SIR_ERROR_TYPE_UNSIGNED_TWICE:
	  return("Type modifier 'unsigned' specified twice");
     case SIR_ERROR_TYPE_CONST_TWICE:
	  return("Type modifier 'const' specified twice");
     case SIR_ERROR_TYPE_VOLATILE_TWICE:
	  return("Type modifier 'volatile' specified twice");
     case SIR_ERROR_TYPE_INT_TWICE:
	  return("Type 'int' specified twice");
     case SIR_ERROR_TYPE_SIGNED_AND_UNSIGNED:
	  return("Type modifier 'signed' and 'unsigned'");
     case SIR_ERROR_TYPE_INTLONGDOUBLE:
	  return("Illegal type 'long int double'");
     case SIR_ERROR_TYPE_MULTIPLE_STORAGE_CLASSES:
	  return("Type with multiple storage classes");
     case SIR_ERROR_UNDEFINED_LABEL:
	  return(SIR_ErrMsg.chars()
	/* "Undefined label '%s'" */);
     case SIR_ERROR_REDEFINITION_OF_LABEL:
	  return(SIR_ErrMsg.chars()
	/* "Redefinition of label '%s'" */);
     case SIR_ERROR_REDEFINITION_OF_USERTYPE_1:
     case SIR_ERROR_REDEFINITION_OF_USERTYPE_2:
	  return(SIR_ErrMsg.chars()
	/* "Redefinition of '%s %s'" */);
     case SIR_ERROR_REDEFINITION_OF_USERTYPE_3:
	  return(SIR_ErrMsg.chars()
	/* "Error while importing:" GL_ERROR_MSG_NEWLINE
		"Redefinition of '%s %s'" */);
     case SIR_ERROR_USERTYPE_MISMATCH_1:
	  return(SIR_ErrMsg.chars()
	/* "Declaration '%s %s' does not match former" GL_ERROR_MSG_NEWLINE
			"declaration '%s %s'" */);
     case SIR_ERROR_USERTYPE_MISMATCH_2:
	  return(SIR_ErrMsg.chars()
	/* "Error while importing:" GL_ERROR_MSG_NEWLINE
		"Declaration '%s %s' does not match former" GL_ERROR_MSG_NEWLINE
		"declaration '%s %s'" */);
     case SIR_ERROR_ILLEGAL_SIZEOF_VOID:
	  return("Illegal type 'void' for sizeof operator");
     case SIR_ERROR_ILLEGAL_SIZEOF_EVENT:
	  return("Illegal type 'event' for sizeof operator");
     case SIR_ERROR_ILLEGAL_SIZEOF_FUNCTION:
	  return("Illegal type 'function type' for sizeof operator");
     case SIR_ERROR_EXPRESSION_NOT_CONSTANT:
	  return("Expression not constant");
     case SIR_ERROR_CONST_EXPR_NOT_INTEGER:
	  return("Constant expression not integer");
     case SIR_ERROR_DIVISION_BY_ZERO:
	  return("Division by zero in constant expression");
     case SIR_ERROR_NOTE_SPECIFIED_TWICE:
	  return(SIR_ErrMsg.chars()
	/* "Note '%s' at %s specified twice" */);
     case SIR_ERROR_NOTE_SPECIFIED_TWICE_2:
	  return(SIR_ErrMsg.chars()
	/* "Error while importing:" GL_ERROR_MSG_NEWLINE
		"Note '%s' at %s specified twice" */);
     case SIR_ERROR_SYMBOL_DEFINED_TWICE_1:
	  return(SIR_ErrMsg.chars()
	/* "Error while importing:" GL_ERROR_MSG_NEWLINE
		"Symbol '%s' defined twice" */);
     case SIR_ERROR_SYMBOL_DEFINED_TWICE_2:
	  return(SIR_ErrMsg.chars()
	/* "Symbol '%s' defined twice" */);
     case SIR_ERROR_SYMBOL_STORAGE_MISMATCH_1:
	  return(SIR_ErrMsg.chars()
	/* "%s of %s '%s'" GL_ERROR_MSG_NEWLINE
		"does not match former declaration:" GL_ERROR_MSG_NEWLINE
		"storage class mismatch" */);
     case SIR_ERROR_SYMBOL_STORAGE_MISMATCH_2:
	  return(SIR_ErrMsg.chars()
	/* "Error while importing:" GL_ERROR_MSG_NEWLINE
		"%s of %s '%s'" GL_ERROR_MSG_NEWLINE
		"does not match former declaration:" GL_ERROR_MSG_NEWLINE
		"storage class mismatch" */);
     case SIR_ERROR_DECLARATION_MISMATCH_1:
	  return(SIR_ErrMsg.chars()
	/* "Error while importing:" GL_ERROR_MSG_NEWLINE
		"Declaration of symbol '%s'" GL_ERROR_MSG_NEWLINE
		"does not match former declaration:" GL_ERROR_MSG_NEWLINE
		"type mismatch" */);
     case SIR_ERROR_DECLARATION_MISMATCH_2:
	  return(SIR_ErrMsg.chars()
	/* "Error while importing:" GL_ERROR_MSG_NEWLINE
		"Declaration of %s '%s'" GL_ERROR_MSG_NEWLINE
		"does not match former declaration:" GL_ERROR_MSG_NEWLINE
		"mismatch of implemented interfaces" */);
     case SIR_ERROR_DECLARATION_MISMATCH_3:
	  return(SIR_ErrMsg.chars()
	/* "Declaration of symbol '%s'" GL_ERROR_MSG_NEWLINE
		"does not match former declaration:" GL_ERROR_MSG_NEWLINE
		"type mismatch" */);
     case SIR_ERROR_DECLARATION_MISMATCH_4:
	  return(SIR_ErrMsg.chars()
	/* "Declaration of %s '%s'" GL_ERROR_MSG_NEWLINE
		"does not match former declaration:" GL_ERROR_MSG_NEWLINE
		"mismatch of implemented interfaces" */);
     case SIR_ERROR_REDEFINITION_OF_SYMBOL:
     case SIR_ERROR_REDEFINITION_OF_FUNCTION:
     case SIR_ERROR_REDEFINITION_OF_BEHAVIOR:
     case SIR_ERROR_REDEFINITION_OF_CHANNEL:
     case SIR_ERROR_REDEFINITION_OF_INTERFACE:
	  return(SIR_ErrMsg.chars()
	/* "Error while importing:" GL_ERROR_MSG_NEWLINE
		"Redefinition of %s '%s'" */);
     case SIR_ERROR_REDEFINITION_OF_SYMBOL_2:
     case SIR_ERROR_REDEFINITION_OF_FUNCTION_2:
     case SIR_ERROR_REDEFINITION_OF_BEHAVIOR_2:
     case SIR_ERROR_REDEFINITION_OF_CHANNEL_2:
     case SIR_ERROR_REDEFINITION_OF_INTERFACE_2:
	  return(SIR_ErrMsg.chars()
	/* "Redefinition of %s '%s'" */);
     case SIR_ERROR_WRITING_SPECC_FILE:
	  return(SIR_ErrMsg.chars()
	/* "Writing to file failed" + GL_SystemErrorMessage() */);
     case SIR_ERROR_DOUBLE_IMP_SYMBOL_NOT_FOUND:
	  return("Error while importing:" GL_ERROR_MSG_NEWLINE
		"double-imported symbol not found (internal)");
     case SIR_ERROR_DOUBLE_IMP_USRTP_NOT_FOUND:
     case SIR_ERROR_DOUBLE_IMP_USRTP_NOT_FOUND_2:
	  return("Error while importing:" GL_ERROR_MSG_NEWLINE
		"double-imported usertype not found (internal)");
     case SIR_ERROR_FORBIDDEN_INITIALIZER:
	  return(SIR_ErrMsg.chars()
	/* "Storage class '%s' forbids initialization" GL_ERROR_MSG_NEWLINE
		"for variable '%s'" */);
     case SIR_ERROR_ILLEGAL_STORAGE_CLASS:
	  return(SIR_ErrMsg.chars()
	/* "Storage class '%s' not allowed %s" */);
     case SIR_ERROR_USERTYPE_DEF_IN_PARAMETERS:
	  return("User-type definition inside parameter list not supported;"
							GL_ERROR_MSG_NEWLINE
		"its scope would be only this definition or declaration,"
							GL_ERROR_MSG_NEWLINE
		"which is probably not what you want");
     case SIR_ERROR_USERTYPE_CYCLIC_NESTING:
	  return(SIR_ErrMsg.chars()
	/* "Cyclic nesting in '%s %s' (internal)" */);
     case SIR_ERROR_INSTANCE_CYCLIC_NESTING:
	  return(SIR_ErrMsg.chars()
	/* "Cyclic dependency in class instantiation '%s' (internal)" */);
     case SIR_ERROR_CLASS_CYCLIC_NESTING:
	  return(SIR_ErrMsg.chars()
	/* "Cyclic nesting in class definition '%s' (internal)" */);
     case SIR_ERROR_NO_MAIN_METHOD:
	  return(SIR_ErrMsg.chars()
	/* "No " GL_MAIN_METHOD_NAME " method declared in behavior '%s'" */);
     case SIR_ERROR_MEMBER_MAIN_NOT_A_METHOD:
	  return(SIR_ErrMsg.chars()
	/* "Type mismatch in behavior '%s':" GL_ERROR_MSG_NEWLINE
		"member '" GL_MAIN_METHOD_NAME "' is not a method" */);
     case SIR_ERROR_MAIN_METHOD_TYPE_MISMATCH:
	  return(SIR_ErrMsg.chars()
	/* "Type mismatch in behavior '%s':" GL_ERROR_MSG_NEWLINE
		"method '" GL_MAIN_METHOD_NAME "' is not 'void main(void)'" */);
     case SIR_ERROR_NO_PORTS_ALLOWED_FOR_MAIN:
	  return("No ports allowed for behavior '" GL_MAIN_BEHAVIOR_NAME "'");
     case SIR_ERROR_NO_INTERFACES_ALLOWED_FR_MAIN:
	  return("No interfaces allowed for behavior '"
					GL_MAIN_BEHAVIOR_NAME "'");
     case SIR_ERROR_COMPOUND_STMNT_NOT_CLEAN:
	  return(SIR_ErrMsg.chars()
	/* "Behavioral hierarchy not clean in compound statement;"
							GL_ERROR_MSG_NEWLINE
		"unable to generate simulation model" */);
     case SIR_ERROR_COMPLEX_MEMBER_INITIALIZER:
	  return(SIR_ErrMsg.chars()
	/* "Complex initializer not supported" GL_ERROR_MSG_NEWLINE
		"for class member '%s'" */);
     case SIR_ERROR_ILLEGAL_INTERFACE_MEMBER:
	  return(SIR_ErrMsg.chars()
	/* "Interface member '%s' is not a function declaration" */);
     case SIR_ERROR_CALL_OF_NON_FUNCTION:
	  return("Call of non-function");
     case SIR_ERROR_INVALID_OPERAND_FOR_CONCAT:
	  return("Invalid operand for concatenation operator:"
							GL_ERROR_MSG_NEWLINE
		"must be bitvector or integral type");
     case SIR_ERROR_INVALID_OPERAND_FOR_BITSLICE:
	  return("Invalid operand for bitslice operator:" GL_ERROR_MSG_NEWLINE
		"must be bitvector or integral type");
     case SIR_ERROR_INVALID_SLICE_FOR_BITSLICE:
	  return(SIR_ErrMsg.chars()
	/* "Invalid slice [%d:%d] for argument type bit[%d:%d]" */);
     case SIR_ERROR_INVALID_ARRAY_INDEX:
	  return("Invalid array index:" GL_ERROR_MSG_NEWLINE
		"must be integer or bitvector type");
     case SIR_ERROR_INVALID_OPERAND_FOR_ARRAY_ACC:
	  return("Invalid left operand for operator []:" GL_ERROR_MSG_NEWLINE
		"must be of array, pointer or bitvector type");
     case SIR_ERROR_INVALID_OPERAND_FOR_COND_EXPR:
	  return("Invalid operand for conditional ? operator");
     case SIR_ERROR_INVALID_OPERAND_FOR_BOOL_OP:
	  return("Invalid operand for boolean operator:" GL_ERROR_MSG_NEWLINE
		"type 'bool' expected");
     case SIR_ERROR_INVALID_OPERAND_FOR_BIT_OP:
	  return("Invalid operand for bitwise logical operator:"
							GL_ERROR_MSG_NEWLINE
		"must be integral or bitvector type");
     case SIR_ERROR_INVALID_OPERAND_FOR_INCR_DECR:
	  return("Invalid operand for pre/post increment/decrement operator:"
							GL_ERROR_MSG_NEWLINE
		"must be integral, floating, bitvector or pointer type");
     case SIR_ERROR_INVALID_OPERAND_FOR_SHIFT_OP:
	  return("Invalid operand for shift operator:" GL_ERROR_MSG_NEWLINE
		"must be integral or bitvector type");
     case SIR_ERROR_INVALID_OPERAND_FOR_MODULO_OP:
	  return("Invalid operand for modulo operator:" GL_ERROR_MSG_NEWLINE
		"must be integral or bitvector type");
     case SIR_ERROR_INVALID_OPERAND_FOR_ARITH_OP:
	  return("Invalid operand for arithmetic operator:"
							GL_ERROR_MSG_NEWLINE
		"must be integral, floating or bitvector type");
     case SIR_ERROR_INVALID_POINTER_ARITHMETIC:
	  return("Invalid pointer arithmetic:" GL_ERROR_MSG_NEWLINE
		"only integral or bitvector type summands allowed");
     case SIR_ERROR_OPERAND_NOT_POINTER_OR_ARRAY:
	  return("Invalid operand for unary * operator:" GL_ERROR_MSG_NEWLINE
		"must be of pointer or array type");
     case SIR_ERROR_ILLEGAL_SIZEOF_CLASS:
	  return("Illegal class type for sizeof operator");
     case SIR_ERROR_PORT_MAPPING_MISMATCH_1:
	  return(SIR_ErrMsg.chars()
	/* "Mismatch in port mapping: %d mappings for %d ports" */);
     case SIR_ERROR_PORT_MAPPING_MISMATCH_2:
	  return(SIR_ErrMsg.chars()
	/* "Type mismatch in port mapping for port %u" */);
     case SIR_ERROR_PORT_MAPPING_MISMATCH_3:
	  return(SIR_ErrMsg.chars()
	/* "Illegal port mapping for port %u:" GL_ERROR_MSG_NEWLINE
		"non-bitvector port prohibits concatenated mapping" */);
     case SIR_ERROR_PORT_MAPPING_MISMATCH_4:
	  return(SIR_ErrMsg.chars()
	/* "Mismatch in port mapping for port %u:" GL_ERROR_MSG_NEWLINE
		"bus width (%d) does not match port width (%d)" */);
     case SIR_ERROR_PORT_MAPPING_MISMATCH_5:
	  return(SIR_ErrMsg.chars()
	/* "Mismatch in port mapping for port %u:" GL_ERROR_MSG_NEWLINE
		"bitvector type expected" */);
     case SIR_ERROR_PORT_MAPPING_MISMATCH_6:
	  return(SIR_ErrMsg.chars()
	/* "Illegal port mapping for port %u:" GL_ERROR_MSG_NEWLINE
	"mapping to piped variable requires port direction 'in' or 'out'" */);
     case SIR_ERROR_PORT_MAPPING_MISMATCH_7:
	  return(SIR_ErrMsg.chars()
	/* "Illegal port mapping for port %u:" GL_ERROR_MSG_NEWLINE
	"port of interface type cannot be left open" */);
     case SIR_ERROR_PORT_MAPPING_MISMATCH_8:
	  return(SIR_ErrMsg.chars()
	/* "Illegal port mapping for port %u:" GL_ERROR_MSG_NEWLINE
	"constant mapping only allowed for 'in' ports" */);
     case SIR_ERROR_PORT_MAPPING_MISMATCH_9:
	  return(SIR_ErrMsg.chars()
	/* "Illegal port mapping for port %u:" GL_ERROR_MSG_NEWLINE
	"open mapping only allowed for 'out' ports" */);
     case SIR_ERROR_PORT_MAPPING_MISMATCH_10:
	  return(SIR_ErrMsg.chars()
	/* "Illegal port mapping for port %u:" GL_ERROR_MSG_NEWLINE
	"instance '%s' port mapped to class '%s' port" */);
     case SIR_ERROR_RESERVED_SYMBOL_NAME:
     case SIR_ERROR_RESERVED_SYMBOL_NAME_2:
	  return(SIR_ErrMsg.chars()
	/* "Name '%s' is reserved in its class" GL_ERROR_MSG_NEWLINE
		"and cannot be %s in its class scope" */);
     case SIR_ERROR_MEMBER_HIDES_USED_GLOBAL_SYMB:
	  return(SIR_ErrMsg.chars()
	/* "Declaration of class member/method '%s'" GL_ERROR_MSG_NEWLINE
		"hides global symbol '%s' from being" GL_ERROR_MSG_NEWLINE
		"referenced by local symbol '%s'" */);
     case SIR_ERROR_LEFT_ARG_NOT_A_POINTER:
	  return("Left argument of '->' operator is not a pointer");
     case SIR_ERROR_NOT_AN_AGGREGATE_OR_CLASS:
	  return("Left argument of member access operator" GL_ERROR_MSG_NEWLINE
		"is not an aggregate type or class");
     case SIR_ERROR_ACCESS_TO_INCOMPLETE_TYPE:
	  return("Access to incomplete aggregate type");
     case SIR_ERROR_ACCESS_TO_INCOMPLETE_INTERFC:
	  return(SIR_ErrMsg.chars()
	/* "Access to incomplete interface '%s" */);
     case SIR_ERROR_ACCESS_TO_INCOMPLETE_IF_1:
	  return(SIR_ErrMsg.chars()
	/* "Access to incomplete interface '%s" GL_ERROR_MSG_NEWLINE
		"of behavior '%s'" */);
     case SIR_ERROR_ACCESS_TO_INCOMPLETE_IF_2:
	  return(SIR_ErrMsg.chars()
	/* "Access to incomplete interface '%s" GL_ERROR_MSG_NEWLINE
		"of channel '%s'" */);
     case SIR_ERROR_IMPLEMENTS_INCOMPLETE_IF:
	  return(SIR_ErrMsg.chars()
	/* "Class '%s' implements incomplete interface '%s'" */);
     case SIR_ERROR_NO_SUCH_MEMBER_IN_USERTYPE:
	  return(SIR_ErrMsg.chars()
	/* "There is no member '%s' in this aggregate type" */);
     case SIR_ERROR_NO_SUCH_METHOD_IMPLEMENTED_1:
	  return(SIR_ErrMsg.chars()
	/* "There is no method '%s' in the list" GL_ERROR_MSG_NEWLINE
		"of implemented interfaces for behavior '%s'" */);
     case SIR_ERROR_NO_SUCH_METHOD_IMPLEMENTED_2:
	  return(SIR_ErrMsg.chars()
	/* "There is no method '%s' in the list" GL_ERROR_MSG_NEWLINE
		"of implemented interfaces for channel '%s'" */);
     case SIR_ERROR_NO_SUCH_METHOD_IN_INTERFACE:
	  return(SIR_ErrMsg.chars()
	/* "There is no method '%s' in interface '%s'" */);
     case SIR_ERROR_CYCLIC_INSTANTIATION:
     case SIR_ERROR_CYCLIC_INSTANTIATION_2:
	  return(SIR_ErrMsg.chars()
	/* "Cyclic instantiation: Class '%s' contains" GL_ERROR_MSG_NEWLINE
		"instances of class '%s'" */);
     case SIR_ERROR_CLASS_CONTAINMENT_CYCLE:
	  return(SIR_ErrMsg.chars()
	/* "Error while importing:" GL_ERROR_MSG_NEWLINE
		"class containment cycle detected;" GL_ERROR_MSG_NEWLINE
		"class '%s' contains itself" */);
     case SIR_ERROR_CLASS_LACKS_IMPLEMENTATION:
	  return(SIR_ErrMsg.chars()
	/* "Class '%s' lacks implementation of method" GL_ERROR_MSG_NEWLINE
		"'%s' declared in interface '%s'" */);
     case SIR_ERROR_CLASS_LACKS_IMPLEMENTATION_2:
	  return(SIR_ErrMsg.chars()
	/* "%s '%s' lacks suitable implementation" GL_ERROR_MSG_NEWLINE
		"of method '%s'" */);
     case SIR_ERROR_IMPLEMENTATION_TYPE_MISMATCH:
	  return(SIR_ErrMsg.chars()
	/* "Type mismatch in class '%s':" GL_ERROR_MSG_NEWLINE
		"method '%s' declared in interface '%s'" GL_ERROR_MSG_NEWLINE
		"does not match the implementation" */);
     case SIR_ERROR_IMPLEMENTATION_TYPE_MISMATCH2:
	  return(SIR_ErrMsg.chars()
	/* "Type mismatch in %s '%s':" GL_ERROR_MSG_NEWLINE
		"type of method '%s'" GL_ERROR_MSG_NEWLINE
		"does not match the implementation" */);
     case SIR_ERROR_LABEL_REQUIRED:
	  return(SIR_ErrMsg.chars()
	/* "Label '%s' is required" */);
     case SIR_ERROR_BITSLICE_OUT_OF_RANGE:
	  return(SIR_ErrMsg.chars()
	/* "Bitslice [%d:%d] out of range for %s[%d:%d]" */);
     case SIR_ERROR_TYPE_VOID_NOT_ALLOWED:
	  return("Type 'void' not allowed here");
     case SIR_ERROR_TYPE_EVENT_NOT_PLAIN:
	  return("Type 'event' not plain");
     case SIR_ERROR_TYPE_AGGREGATE_NOT_DEFINED:
	  return(SIR_ErrMsg.chars()
	/* "Aggregate type '%s %s' declared, but not defined" */);
     case SIR_ERROR_TYPE_FUNCTION_RETURNS_ARRAY:
	  return("Function return type cannot be an array");
     case SIR_ERROR_PORT_DIRECTION_REQUIRED:
	  return("Port direction required for type");
     case SIR_ERROR_ILLEGAL_PORT_DIRECTION:
	  return("Illegal port direction for type");
     case SIR_ERROR_METHOD_IS_IMPLEMENTED:
	  return(SIR_ErrMsg.chars()
	/* "Method '%s' is implemented by %s" GL_ERROR_MSG_NEWLINE
		"and therefore cannot be modified" */);
     case SIR_ERROR_DOUBLE_DEFINITION_OF_LABEL:
	  return(SIR_ErrMsg.chars()
	/* "Double definition of label '%s'" */);
     case SIR_ERROR_RETURN_TYPE_MISMATCH:
	  return("Return type mismatch:" GL_ERROR_MSG_NEWLINE
		"expression cannot be converted to function return type");
     case SIR_ERROR_ARGUMENT_TYPE_MISMATCH:
	  return("Argument type mismatch in function call");
     case SIR_ERROR_TOO_MANY_ARGUMENTS:
	  return("Too many arguments in function call");
     case SIR_ERROR_TOO_FEW_ARGUMENTS:
	  return("Too few arguments in function call");
     case SIR_ERROR_COMPLEX_INIT_FOR_PLAIN_TYPE:
	  return(SIR_ErrMsg.chars()
	/* "Complex initializer for type '%s'" */);
     case SIR_ERROR_COMPLEX_INIT_FOR_POINTER_TYPE:
	  return("Complex initializer for pointer type");
     case SIR_ERROR_INITIALIZER_TYPE_MISMATCH:
	  return(SIR_ErrMsg.chars()
	/* "Initializer type mismatch:" GL_ERROR_MSG_NEWLINE
		"cannot convert '%s' to %s" */);
     case SIR_ERROR_ILLEGAL_INITIALIZER:
	  return(SIR_ErrMsg.chars()
	/* "Illegal initializer %s:" GL_ERROR_MSG_NEWLINE
		"%s cannot be initialized" */);
     case SIR_ERROR_INIT_INCOMPLETE_STRUCTURE:
	  return("Initializer for incomplete structure");
     case SIR_ERROR_PLAIN_INIT_FOR_STRUCTURE:
	  return(SIR_ErrMsg.chars()
	/* "Plain initializer '%s' for structure type" */);
     case SIR_ERROR_PLAIN_INIT_FOR_ARRAY:
	  return(SIR_ErrMsg.chars()
	/* "Plain initializer '%s' for array type" */);
     case SIR_ERROR_TOO_MANY_INITIALIZERS_1:
	  return("Too many initializers for structure");
     case SIR_ERROR_TOO_MANY_INITIALIZERS_2:
	  return("Too many initializers for array");
     case SIR_ERROR_INVALID_ARRAY_ASSIGNMENT:
	  return("Invalid array assignment");
     case SIR_ERROR_TIME_CONSTRAINT_UNSPECIFIED:
	  return("Time constraint unspecified");
     case SIR_ERROR_CONSTRAINT_LABEL_NOT_IN_DO:
	  return("Constraint label not in do-statement list");
     case SIR_ERROR_CONSTRAINT_ALREADY_EXISTS:
	  return("Constraint already exists");
     case SIR_ERROR_CREATED_INTERFACE_NOT_FOUND:
	  return("Created interface not found (internal)");
     case SIR_ERROR_MODIFIABLE_LVALUE:
	  return(SIR_ErrMsg.chars()
	/* "Modifiable lvalue expected%s" */);
     case SIR_ERROR_PORT_WRITE_ACCESS:
	  return(SIR_ErrMsg.chars()
	/* "Write access to input port%s" */);
     case SIR_ERROR_PORT_READ_ACCESS:
	  return(SIR_ErrMsg.chars()
	/* "Read access to output port%s" */);
    } /* hctiws */

return("Unknown error number (internal)");

} /* end of SIR_ErrorText */


/************************************************************************/
/*** implementation of internal functions			      ***/
/************************************************************************/


	/* none */


/* EOF Error.c */
