/************************************************************************/
/* Declarator.cc: SpecC Internal Representation, Declarator Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 02/10/98 */
/************************************************************************/

/* last update: 03/12/99 */

/* NOTE: This file contains special support for the SpecC parser. */
/*       It is not used in a standard SpecC data structure.	  */


#include "IntRep/Declarator.h"

#include <assert.h>


/*** constants and macros ***********************************************/


	/* none */


/*** internal type declarations *****************************************/


	/* none */


/*** class implementations **********************************************/


	/**********************/
	/*** SIR_Declarator ***/
	/**********************/


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Declarator::SIR_Declarator(		/* constructor #1 (general) */
	sir_type_list	*DeclTypes,
	const char	*SymbolName = NULL,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL,
	unsigned int	BitFieldSize = 0)
{

SIR_Declarator::DeclTypes	= DeclTypes;
SIR_Declarator::Parameters	= NULL;
SIR_Declarator::ParamScope	= NULL;
if (SymbolName)
   { SIR_Declarator::SymbolName	= new string(SymbolName);
    } /* fi */
else
   { SIR_Declarator::SymbolName	= NULL;
    } /* esle */
SIR_Declarator::Line		= Line;
SIR_Declarator::FileInfo	= FileInfo;
SIR_Declarator::BitFieldSize	= BitFieldSize;

} /* end of SIR_Declarator::SIR_Declarator #1 */


SIR_Declarator::SIR_Declarator(		/* constructor #2 (function support) */
	sir_type	*FirstDeclType,
	sir_parameters	*Parameters = NULL,
	sir_symbols	*ParamScope = NULL)
{

SIR_Declarator::DeclTypes	= new sir_type_list(FirstDeclType);
SIR_Declarator::Parameters	= Parameters;
SIR_Declarator::ParamScope	= ParamScope;
SIR_Declarator::SymbolName	= NULL;
SIR_Declarator::Line		= 0;
SIR_Declarator::FileInfo	= NULL;
SIR_Declarator::BitFieldSize	= 0;

} /* end of SIR_Declarator::SIR_Declarator #2 */


SIR_Declarator::~SIR_Declarator(void)	/* destructor */
{

delete DeclTypes;
delete Parameters;
delete ParamScope;
delete SymbolName;

} /* end of SIR_Declarator::~SIR_Declarator */


	/********************/
	/*** SIR_DeclSpec ***/
	/********************/


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_DeclSpec::SIR_DeclSpec(		/* constructor #1 (general) */
	sir_type	*BaseType,
	SIR_STORAGE	StorageClass = SIR_STORAGE_NONE,
	int		PipeStages = 0)
{

SIR_DeclSpec::BaseType		= BaseType;
SIR_DeclSpec::StorageClass	= StorageClass;
SIR_DeclSpec::PipeStages	= PipeStages;
SIR_DeclSpec::MemberList	= NULL;

} /* end of SIR_DeclSpec::SIR_DeclSpec #1 */


SIR_DeclSpec::SIR_DeclSpec(		/* constructor #2 (from BasicType) */
	sir_types	*TypeTable,
	sir_basic_type	*BasicType)
{

assert(TypeTable != NULL);
assert(BasicType != NULL);

SIR_DeclSpec::BaseType		= TypeTable->FindOrInsert(BasicType);
SIR_DeclSpec::StorageClass	= BasicType->StorageClass;
SIR_DeclSpec::PipeStages	= BasicType->PipeStages;
SIR_DeclSpec::MemberList	= NULL;

} /* end of SIR_DeclSpec::SIR_DeclSpec #2 */


SIR_DeclSpec::~SIR_DeclSpec(void)	/* destructor */
{

delete MemberList;

} /* end of SIR_DeclSpec::~SIR_DeclSpec */


/*** exported functions *************************************************/


	/* none */


/* EOF Declarator.cc */
