// Init.sc: implicit initialization of static variables

#include <stdio.h>
#include <assert.h>

// note: (taken from annotated C++ standard (draft), available at
//	 http://www.csci.csusb.edu/dick/c++std/cd2/decl.html#dcl.init)
//
// 6 The memory occupied by any object of static storage duration shall  be
//   zero-initialized  at  program  startup before any other initialization
//   takes place.  [Note: in some cases, additional initialization is  done
//   later.  ]
//
// Given this guarantee, we simply accomplish the required initializations
// for SpecC by allocating the instantiation tree in static memory.
// RD, 05/23/01.

extern int	GlobalVariableDecl;		// no init	(by other)

int		GlobalVariable;			// INIT!	(by C++)

static int	GlobalStaticVariable;		// INIT!	(by C++)

int	GlobalFunction(int Arg, int UnusedArg)	// no init	(on stack)
	{
	int	LocalVariable;			// no init	(on stack)

	static int LocalStatic;			// INIT!	(by C++)

//	extern int LocalExtern;			// no init	(by other)

//	printf("LocalVariable is %d.\n", LocalVariable);
//	assert(LocalVariable == 0);
	printf("LocalStatic is %d.\n", LocalStatic);
	assert(LocalStatic == 0);
	LocalVariable = Arg;
	while(LocalVariable < 100)
		{ int CompoundLocal;		// no init	(on stack)

		  static int CompoundStatic;	// INIT!	(by C++)

//		  extern int CompoundExtern;	// no init	(by other)

//		  printf("CompoundLocal is %d.\n", CompoundLocal);
//		  assert(CompoundLocal == 0);
		  printf("CompoundStatic is %d.\n", CompoundStatic);
		  assert(CompoundStatic == 0);
		  CompoundLocal = Arg + CompoundStatic;
		  LocalVariable += CompoundLocal;
		 }
	return(LocalVariable + LocalStatic);
	}

int	GlobalFunctionDecl(int Arg);		// no init	(by other)


interface InterfaceDecl;			// no init	(by other)

interface I
{
int	Method1(void);				// no init	(by C++)
// no storage classes allowed
// no variables allowed
};


channel ChannelDecl(void) implements I;		// no init	(by C++/SpecC)

channel C (void) implements I			// no init	(by C++)
{
int		ChannelVariable;		// INIT!	(BY SPECC!!!)
// no storage classes allowed

int	Method1(void)				// no init	(by C++)
	{
	printf("ChannelVariable is %d.\n", ChannelVariable);
	assert(ChannelVariable == 0);
	return ChannelVariable;
	}
};


behavior BehaviorDecl(int);			// no init	(by other)

behavior B (in int p1, out int p2)		// no init	(by C++/SpecC)
{
int	BehaviorVariable;			// INIT!	(BY SPECC!!!)

C	ChannelInst;				// INIT!	(by C++)

int	LocalMethodDecl(void);			// no init	(by C++)

int	LocalMethod(void)			// no init	(by C++)
	{
	int	MethodVariable;			// no init	(on stack)

	static int MethodStatic;		// INIT!	(by C++)

//	extern int MethodExtern;		// no init	(by other)

//	printf("MethodVariable is %d.\n", MethodVariable);
//	assert(MethodVariable == 0);
	printf("MethodStatic is %d.\n", MethodStatic);
	assert(MethodStatic == 0);
	MethodVariable = MethodStatic;
	return MethodVariable;
	}

void main(void)
	{
	printf("BehaviorVariable is %d.\n", BehaviorVariable);
	assert(BehaviorVariable == 0);
	p2 = p1 + LocalMethod();
	}
};


behavior Main
{
	int	x, y;
	C	c;
	B	b(x, y);

	int main(void)
	{
	int	Result;

	printf("GlobalVariable is %d.\n", GlobalVariable);
	assert(GlobalVariable == 0);
	printf("GlobalStaticVariable is %d.\n", GlobalStaticVariable);
	assert(GlobalStaticVariable == 0);
	Result = GlobalFunction(50, -1);
	assert(Result == 100);
	Result = c.Method1();
	assert(Result == 0);
	x = 100;
	b.main();
	assert(y == 100);
	return(0);
	}
};

// EOF Init.sc
