// cond.sc

// Test for conditional expression operator (operator?) with bit vectors

// Normal operand promotion rules apply:
//  * Result type is sign, length of largest operand
//  * If operands have same length, result is unsigned if at least one
//    of the operands is unsigned
// -> Both operands get promoted to result type


behavior Main(void)
{
  int main(int argc, char* argv[])
  {
    bit[2:0]  a;
    bit[15:0] b;
    bit[128:0] c;
    unsigned bit[2:0]  au;
    unsigned bit[15:0] bu;

    au = a = -1;
    bu = b = -1;
    
    // Both operands are bit vectors
    c = (a) ? a  : au;          if( c < 0 ) return 1;
    c = (a) ? a  : b;           if( c > 0 ) return 1;    
    c = (b) ? a  : bu;          if( c < 8 ) return 1;
    c = (b) ? au : bu;          if( c < 0 ) return 1;

    // Bit vector & constant
    c = (!a)? a  : 11b;         if( c > 0 ) return 1;
    c = (!a)? au : 11b;         if( c < 4 ) return 1;
    c = (!a)? a  : 11ub;        if( c < 0 ) return 1;
    c = (!a)? au : 11ub;        if( c < 0 ) return 1;
    
    // Bit vector & integral
    c = (a) ?  a : 5;           if( c > 0 ) return 1;
    c = (a) ?  a : 5l;          if( c > 0 ) return 1;
    c = (a) ?  a : 5ll;         if( c > 0 ) return 1;
    c = (a) ?  a : 5u;          if( c < 8 ) return 1;
    c = (a) ?  a : 5ul;         if( c < 8 ) return 1;
    c = (a) ?  a : 5ull;        if( c < 8 ) return 1;
    c = (a) ? au : 5;           if( c < 0 ) return 1;
    c = (a) ? au : 5l;          if( c < 0 ) return 1;
    c = (a) ? au : 5ll;         if( c < 0 ) return 1;
    c = (a) ? au : 5u;          if( c < 0 ) return 1;
    c = (a) ? au : 5ul;         if( c < 0 ) return 1;
    c = (a) ? au : 5ull;        if( c < 0 ) return 1;
    
    // Bit vector & bit slice
    c = (!a)?  a :  b[3:0];     if( c > 0 ) return 1;
    c = (a) ?  a : bu[14:0];    if( c < 8 ) return 1;
    c = (!a)? au :  b[1:0];     if( c < 4 ) return 1;
    c = (!a)? au : bu[3:0];     if( c < 0 ) return 1;
    
    // Bit vector & temporary
    c = (a) ?  a:  a + b;       if( c > 0 ) return 1;
    c = (a) ?  a: au + bu;      if( c < 8 ) return 1;
    c = (a) ? au:  a + b;       if( c < 0 ) return 1;
    c = (a) ? au: au + bu;      if( c < 0 ) return 1;
    c = (a) ?  a:  a + 5;       if( c > 0 ) return 1;
    c = (a) ?  a: au + 5u;      if( c < 8 ) return 1;
    c = (a) ?  a: -b;           if( c > 0 ) return 1;
    c = (a) ?  a: -bu;          if( c < 8 ) return 1;

    // Bit slice & temporary
    c = (a) ?  a[1:0]:  a + b;         if( c > 0 ) return 1;
    c = (a) ?  a[1:0]: au + bu;        if( c < 4 ) return 1;
    c = (a) ? au[1:0]:  a + b;         if( c < 0 ) return 1;
    c = (a) ? au[1:0]: au + bu;        if( c < 0 ) return 1;
    c = (a) ?  a[1:0]:  a + 5;         if( c > 0 ) return 1;
    c = (a) ?  a[1:0]: au + 5u;        if( c < 4 ) return 1;
    c = (a) ?  a[1:0]: -b;             if( c > 0 ) return 1;
    c = (a) ?  a[1:0]: -bu;            if( c < 4 ) return 1;
        
    return 0;
  }
};



