/************************************************************************/
/* Parser.h: SpecC parser						*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 08/13/97 */
/************************************************************************/

/* last update: 05/30/01 */

/* modifications: (most recent first)
 *
 * 05/30/01 RD	reduced contents to reference compiler needs
 * 05/27/01 RD	added semantic checking for event port accesses
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 05/04/01 RD	added support for import of SpecC source (.sc) files
 * 05/03/01 RD	added PRS_ERROR_IMPORT_FILE_NOT_FOUND
 * 04/18/01 RD	added PRS_ERROR_NEGATIVE_ARRAY_SIZE
 * 03/08/01 RD	added flag for constant-check for 'waitfor' argument
 * 02/12/01 RD	added PRS_ERROR_BITVECTOR_LENGTH
 */


#ifndef PARSER_H
#define PARSER_H


#include "Global.h"
#include "IntRep.h"
#include "IntRep/Declarator.h"	/* include special parser support also */
#include "IntRep/BasicType.h"


/*** constants and macros ***********************************************/


	/* options */

#define PRS_KEEP_REDUNDANT_PARENTHESES	/* don't throw them away */
/* #define PRS_EVALUATE_WAITFOR */	/* allow non-constant time at waitfor */


	/* flags for DEBUG modes */

/* #define PRS_DEBUG */		/* enable my own debugging code */
/* #define YYDEBUG 1 */		/* include bison's debugging code */

#ifdef YYDEBUG
extern int	PRS_debug;	/* debugging switch */
#endif /* YYDEBUG */


	/* error codes for this module */
#define PRS_ERROR_NO_ERROR			(NO_ERROR)
#define PRS_ERROR_OUT_OF_MEMORY			(PRS_ERROR_BASE +  1)
#define PRS_ERROR_PARSE_ERROR			(PRS_ERROR_BASE +  2)
#define PRS_ERROR_UNDECLARED_IDENTIFIER		(PRS_ERROR_BASE +  3)
#define PRS_ERROR_UNDECLARED_IDENTIFIER_2	(PRS_ERROR_BASE +  4)
#define PRS_ERROR_SEMANTIC_ERROR		(PRS_ERROR_BASE +  5)
#define PRS_ERROR_TYPE_CONST_TWICE		(PRS_ERROR_BASE +  6)
#define PRS_ERROR_TYPE_VOLATILE_TWICE		(PRS_ERROR_BASE +  7)
#define PRS_ERROR_PARAMETER_STORAGE_CLASS	(PRS_ERROR_BASE +  8)
#define PRS_ERROR_FUNCTION_DECLARATOR_EXPECTED	(PRS_ERROR_BASE +  9)
#define PRS_ERROR_BAD_STORAGECLASS_FOR_FUNCTION	(PRS_ERROR_BASE + 10)
#define PRS_ERROR_UNDEFINED_SYMBOL_FOR_NOTE	(PRS_ERROR_BASE + 11)
#define PRS_ERROR_EVENT_TYPE_MISMATCH		(PRS_ERROR_BASE + 12)
#define PRS_ERROR_ILLEGAL_BITFIELD_SIZE		(PRS_ERROR_BASE + 13)
#define PRS_ERROR_ILLEGAL_BITFIELD_TYPE		(PRS_ERROR_BASE + 14)
#define PRS_ERROR_ILLEGAL_TYPE			(PRS_ERROR_BASE + 15)
#define PRS_ERROR_CONST_EXPR_NOT_INTEGER	(PRS_ERROR_BASE + 16)
#define PRS_ERROR_EMPTY_FILENAME		(PRS_ERROR_BASE + 17)
#define PRS_ERROR_NOT_BEHAVIOR_INSTANCE		(PRS_ERROR_BASE + 18)
#define PRS_ERROR_STATE_LABEL_DEFINED_TWICE	(PRS_ERROR_BASE + 19)
#define PRS_ERROR_STATE_LABEL_NOT_DEFINED	(PRS_ERROR_BASE + 20)
#define PRS_ERROR_PORT_MAPPING_1		(PRS_ERROR_BASE + 21)
#define PRS_ERROR_PORT_MAPPING_2		(PRS_ERROR_BASE + 22)
#define PRS_ERROR_USERTYPE_IN_PORT_LIST		(PRS_ERROR_BASE + 23)
#define PRS_ERROR_NOTES_RESTRICTED_TO_FCTBODY	(PRS_ERROR_BASE + 24)
#define PRS_ERROR_NOTES_RESTRICTED_TO_FCTBODY2	(PRS_ERROR_BASE + 25)
#define PRS_ERROR_CONSTANT_PARSING_FAILED	(PRS_ERROR_BASE + 26)
#define PRS_ERROR_TYPE_MISMATCH_IN_RETURN	(PRS_ERROR_BASE + 27)
#define PRS_ERROR_UNDEFINED_LABEL_IN_RANGE	(PRS_ERROR_BASE + 28)
#define PRS_ERROR_REDEFINED_CONSTRAINT		(PRS_ERROR_BASE + 29)
#define PRS_ERROR_CONSTRAINT_LABEL_NOT_IN_DO	(PRS_ERROR_BASE + 30)
#define PRS_ERROR_BITVECTOR_LENGTH		(PRS_ERROR_BASE + 31)
#define PRS_ERROR_NEGATIVE_ARRAY_SIZE		(PRS_ERROR_BASE + 32)
#define PRS_ERROR_IMPORT_FILE_NOT_FOUND		(PRS_ERROR_BASE + 33)
#define PRS_ERROR_CYCLIC_IMPORT			(PRS_ERROR_BASE + 34)
#define PRS_ERROR_IMPORT_FAILED			(PRS_ERROR_BASE + 35)
#define PRS_ERROR_NOTIFY_INPUT_PORT_1		(PRS_ERROR_BASE + 36)
#define PRS_ERROR_NOTIFY_INPUT_PORT_2		(PRS_ERROR_BASE + 37)
#define PRS_ERROR_WAIT_OUTPUT_PORT		(PRS_ERROR_BASE + 38)
#define PRS_ERROR_TRAP_OUTPUT_PORT		(PRS_ERROR_BASE + 39)
#define PRS_ERROR_INTERRUPT_OUTPUT_PORT		(PRS_ERROR_BASE + 40)


	/* file suffixes */

#define	PRS_IMPORT_SC_FILE_SUFFIX	".sc"
#define	PRS_IMPORT_SI_FILE_SUFFIX	".si"


	/* temporary file location */

#ifndef PRS_IMPORT_TMP_DIR		/* should be set from outside */
#define PRS_IMPORT_TMP_DIR		"/tmp"	/* default */
#endif /* PRS_IMPORT_TMP_DIR */


/*** type definitions ***************************************************/


	/* none */


/*** exported variables *************************************************/


extern ERROR		PRS_Error;		/* last error of this module */

extern unsigned int	PRS_NumberOfLines;	/* number lines processed */


/************************************************************************/
/*** prototype definitions for exported functions		      ***/
/************************************************************************/


	/*** error handling ***/

	/* recover from error status */

extern void PRS_Reset(void);

	/* error code to error message conversion */

extern const char *PRS_ErrorText(ERROR ErrorNumber);

	/* error message handling */

extern void PRS_error(			/* note the error message #1 */
	const char	*Msg);

extern void PRS_error(			/* note the error message #2 */
	const char	*Msg,
	ERROR		Error,
	unsigned int	Line,
	const char	*File);

extern void PRS_error(			/* note the error message #3 */
	const char	*Msg,
	ERROR		Error);

extern void PRS_SemanticError(		/* handle sub-module error messages */
	ERROR		Error,
	sir_node	*Node1 = NULL,
	sir_node	*Node2 = NULL,
	sir_node	*Node3 = NULL);

extern void PRS_PrintWarning(		/* print a warning message */
	int		WarnLevel,
	const char	*Msg);


	/*** parser supporting functions ***/


extern ERROR PRS_CheckTypeDefinition(	/* checks if type is legal here */
	sir_type	*TypeEntry,
	bool		VoidIsOK = false,
	bool		IsPort = false,
	SIR_STORAGE	StorageClass = SIR_STORAGE_NONE,
	unsigned int	Line = 0,
	const char	*Filename = NULL);


	/*** main functionality ***/


extern sir_design *PRS_ParseDesign(	/* parse a whole design (#1) */
	FILE		*FromFile,	/* from a file */
	const char	*DesignName,	/* (returns a new SIR data structure */
	const char	*FileName,	/*  or NULL and PRS_Error) */
	GL_STRINGLIST	*ImportDirs = NULL);


#endif /* PARSER_H */

/* EOF Parser.h */
